/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor.links;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.xmleditor.mpeditor.links.FragmentXPointer;
import info.textgrid.lab.xmleditor.mpeditor.links.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NodeToLinkAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_LIST = new Class[]{Document.class, IFile.class, TextGridObject.class, URI.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        Node node = (Node)AdapterUtils.getAdapter((Object)adaptableObject, Node.class);
        if (node != null) {
            Document document = this.getDocument(node);
            if (adapterType.isAssignableFrom(document.getClass())) {
                return document;
            }
            IFile file = this.getFile(document);
            if (adapterType.isAssignableFrom(IFile.class)) {
                return file;
            }
            URI documentURI = null;
            if (file != null) {
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)file, TextGridObject.class);
                if (adapterType.isAssignableFrom(TextGridObject.class)) {
                    return textGridObject;
                }
                documentURI = textGridObject != null ? textGridObject.getURI() : file.getLocationURI();
            }
            if (adapterType.isAssignableFrom(URI.class)) {
                String fragment = FragmentXPointer.of(node).toString();
                try {
                    return new URI(documentURI == null ? "" : String.valueOf(documentURI.toString()) + fragment);
                }
                catch (URISyntaxException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.xmleditor.mpeditor", MessageFormat.format(Messages.NodeToLinkAdapterFactory_ErrorAssemblingLink, documentURI, fragment, e.getMessage()), (Throwable)e));
                }
            }
        }
        return null;
    }

    private IFile getFile(Document document) {
        IDOMDocument doc = (IDOMDocument)AdapterUtils.getAdapter((Object)document, IDOMDocument.class);
        if (doc != null) {
            String baseLocation = doc.getModel().getBaseLocation();
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(baseLocation));
        }
        return null;
    }

    private Document getDocument(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        return document;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

