/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor.views;

import com.google.common.base.Predicate;
import info.textgrid.lab.core.swtutils.annotations.ActiveEditorAnnotationViewerController;
import info.textgrid.lab.core.swtutils.annotations.AnnotationContentProvider;
import info.textgrid.lab.xmleditor.mpeditor.Activator;
import info.textgrid.lab.xmleditor.mpeditor.views.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeContentProvider;

public class ValidationErrorsView
extends ViewPart {
    public static final String ID = "info.textgrid.lab.xmleditor.mpeditor.views.ValidationErrors";
    private TableViewer viewer;
    private ActiveEditorAnnotationViewerController controller;

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 65540);
        AnnotationContentProvider contentProvider = new AnnotationContentProvider();
        contentProvider.setFilter((Predicate)new Predicate<Annotation>(){

            public boolean apply(Annotation input) {
                return input.getType().startsWith("org.eclipse.wst.sse.ui.temp.");
            }
        });
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.getTable().setHeaderVisible(true);
        TableViewerColumn messageColumn = new TableViewerColumn(this.viewer, 16384);
        messageColumn.getColumn().setText(Messages.ValidationErrorsView_ErrorMsg);
        messageColumn.getColumn().setWidth(400);
        messageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }

            public String getText(Object element) {
                if (element instanceof Annotation) {
                    Annotation annotation = (Annotation)element;
                    return annotation.getText();
                }
                return MessageFormat.format(Messages.ValidationErrorsView_NotAnnotation, element, element.getClass());
            }

            public String getToolTipText(Object element) {
                if (element instanceof Annotation) {
                    return ((Annotation)element).getText();
                }
                return super.getToolTipText(element);
            }
        });
        TableViewerColumn textColumn = new TableViewerColumn(this.viewer, 16384);
        textColumn.getColumn().setText(Messages.ValidationErrorsView_InvalidXML);
        textColumn.getColumn().setWidth(100);
        textColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            ILabelProvider xmlLabelProvider = new XMLTableTreeContentProvider();

            public String getText(Object element) {
                if (element instanceof Annotation) {
                    Annotation annotation = (Annotation)element;
                    IndexedRegion region = this.getIndexedRegion(annotation);
                    String nodeLabel = this.xmlLabelProvider.getText((Object)region);
                    if (!"".equals(nodeLabel)) {
                        return nodeLabel;
                    }
                    return annotation.getText();
                }
                return null;
            }

            public Image getImage(Object element) {
                IndexedRegion region;
                if (element instanceof Annotation && (region = this.getIndexedRegion((Annotation)element)) != null) {
                    return this.xmlLabelProvider.getImage((Object)region);
                }
                return super.getImage(element);
            }

            private IndexedRegion getIndexedRegion(Annotation annotation) {
                Position position = ValidationErrorsView.this.controller.getAnnotationModel().getPosition(annotation);
                IDocument currentDocument = ValidationErrorsView.this.controller.getCurrentDocument();
                if (currentDocument != null && position != null) {
                    IStructuredModel model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)currentDocument);
                    IndexedRegion region = model.getIndexedRegion(position.offset);
                    model.releaseFromRead();
                    return region;
                }
                Activator.handleProblem(2, new IllegalStateException(), "Something strange has happened: We should label annotation {0} in document {1} with position {2}, but something is null.", annotation, currentDocument, position);
                return null;
            }
        });
        TableViewerColumn offsetColumn = new TableViewerColumn(this.viewer, 131072);
        offsetColumn.getColumn().setWidth(50);
        offsetColumn.getColumn().setText(Messages.ValidationErrorsView_Offset);
        offsetColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Position position;
                if (element instanceof Annotation && ValidationErrorsView.this.controller.getAnnotationModel() != null && (position = ValidationErrorsView.this.controller.getAnnotationModel().getPosition((Annotation)element)) != null) {
                    return Integer.toString(position.getOffset());
                }
                return null;
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Annotation && e2 instanceof Annotation) {
                    Position position1 = ValidationErrorsView.this.controller.getAnnotationModel().getPosition((Annotation)e1);
                    if (position1 == null) {
                        return 0;
                    }
                    int offset1 = position1.offset;
                    Position position2 = ValidationErrorsView.this.controller.getAnnotationModel().getPosition((Annotation)e2);
                    if (position2 == null) {
                        return 0;
                    }
                    int offset2 = position2.offset;
                    return offset1 - offset2;
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Annotation annotation = (Annotation)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (annotation != null) {
                    Position position = ValidationErrorsView.this.controller.getAnnotationModel().getPosition(annotation);
                    ITextEditor textEditor = ValidationErrorsView.this.controller.getTextEditor();
                    if (position != null && textEditor != null) {
                        textEditor.selectAndReveal(position.getOffset(), position.getLength());
                    }
                }
            }
        });
        this.controller = new ActiveEditorAnnotationViewerController((AbstractTableViewer)this.viewer);
        this.getSite().getPage().addPartListener((IPartListener)this.controller);
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor != null) {
            this.controller.partActivated((IWorkbenchPart)activeEditor);
        }
    }

    public void dispose() {
        if (this.controller != null) {
            this.getSite().getPage().removePartListener((IPartListener)this.controller);
        }
        super.dispose();
    }

    public void setFocus() {
    }
}

