/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.treeWriter;

import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.CoreException;

public class TreeWriter {
    private XMLStreamWriter writer;
    private final String namespace = "http://textgrid.info/namespaces/webpublisher";

    private void writeElement(Object object) throws XMLStreamException {
        if (object instanceof TGOentry) {
            this.writer.writeStartElement("item");
            this.writer.writeAttribute("uri", ((TGOentry)object).getTgo().getURI().toString());
            try {
                this.writer.writeAttribute("format", ((TGOentry)object).getTgo().getContentTypeID());
            }
            catch (CoreException e) {
                AggregationsUIPlugin.handleError(e, "Treewriter Error", new Object[0]);
            }
            this.writer.writeEndElement();
        } else if (object instanceof Aggregation) {
            this.writer.writeStartElement("container");
            this.writer.writeAttribute("name", ((Aggregation)object).getName());
            this.writer.writeAttribute("id", ((Aggregation)object).getUuid());
            Object[] children = ((Aggregation)object).getChildren();
            int i = 0;
            while (i < children.length) {
                this.writeElement(children[i]);
                ++i;
            }
            this.writer.writeEndElement();
        }
    }

    public byte[] writeTree(Aggregation root, String description, Boolean includeRef) throws XMLStreamException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.writer = factory.createXMLStreamWriter(outstream);
        this.writer.writeStartDocument();
        this.writer.setDefaultNamespace("http://textgrid.info/namespaces/webpublisher");
        this.writer.writeStartElement("publication");
        this.writer.writeDefaultNamespace("http://textgrid.info/namespaces/webpublisher");
        this.writer.writeAttribute("includeRef", includeRef.toString());
        this.writer.writeStartElement("description");
        this.writer.writeCharacters(description);
        this.writer.writeEndElement();
        Object[] objects = root.getChildren();
        int i = 0;
        while (i < objects.length) {
            this.writeElement(objects[i]);
            ++i;
        }
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.close();
        try {
            outstream.flush();
        }
        catch (IOException e) {
            AggregationsUIPlugin.handleError(e, "Treewriter Error", new Object[0]);
        }
        return outstream.toByteArray();
    }
}

