/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.views;

import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.ISectionListener;
import info.textgrid.lab.core.aggregations.ui.model.SectionEvent;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SectionContentProvider
implements ITreeContentProvider,
ISectionListener {
    private TreeViewer viewer;

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == null) {
            return new Aggregation[0];
        }
        if (parentElement instanceof Aggregation) {
            return ((Aggregation)parentElement).getChildren();
        }
        return null;
    }

    public Object[] getElements(Object input) {
        return this.getChildren(input);
    }

    public Object getParent(Object element) {
        if (element instanceof Aggregation) {
            return ((Aggregation)element).getParent();
        }
        if (element instanceof TGOentry) {
            return ((TGOentry)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Aggregation) {
            return this.getChildren(element).length > 0;
        }
        return false;
    }

    public void inputChanged(Viewer v, Object old, Object newt) {
        this.viewer = (TreeViewer)v;
        if (old != null) {
            this.removeListenerFrom((Aggregation)old);
        }
        if (newt != null) {
            this.addListenerTo((Aggregation)newt);
        }
    }

    protected void addListenerTo(Aggregation aggregation) {
        aggregation.addListener(this);
        Object[] children = aggregation.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Aggregation) {
                this.addListenerTo((Aggregation)children[i]);
            }
            ++i;
        }
    }

    protected void removeListenerFrom(Aggregation aggregation) {
        aggregation.removeListener(this);
        Object[] children = aggregation.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Aggregation) {
                this.removeListenerFrom((Aggregation)children[i]);
            }
            ++i;
        }
    }

    @Override
    public void add(SectionEvent event) {
        Object receiver = event.receiver();
        if (receiver instanceof Aggregation) {
            Aggregation aggregation = (Aggregation)receiver;
            this.addListenerTo(aggregation);
            this.viewer.setSelection((ISelection)new StructuredSelection(receiver), true);
        } else if (receiver instanceof TGOentry) {
            TGOentry cfr_ignored_0 = (TGOentry)receiver;
            this.viewer.setSelection((ISelection)new StructuredSelection(receiver), true);
        }
    }

    @Override
    public void remove(SectionEvent event) {
        Object receiver = event.receiver();
        if (receiver instanceof Aggregation) {
            Aggregation aggregation = (Aggregation)receiver;
            this.removeListenerFrom(aggregation);
        } else if (receiver instanceof TGOentry) {
            TGOentry cfr_ignored_0 = (TGOentry)receiver;
        }
    }

    @Override
    public void rename(SectionEvent event) {
        Object receiver = event.receiver();
        this.viewer.update(receiver, null);
    }
}

