/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.revisions.ui;

import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.revisions.ui.Messages;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class RevisionSelectDialog
extends TitleAreaDialog {
    private TextGridObjectTableViewer viewer;
    private Button buttonOK;
    private Object objTest;
    private TextGridObject tgo;
    private Object selObj;

    public RevisionSelectDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.RevisionSelectDialog_ReferToRevision);
        this.setMessage(Messages.RevisionSelectDialog_IM_SelectRevision, 1);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData gdMain = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gdMain);
        this.viewer = new TextGridObjectTableViewer(container, 772);
        this.viewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.REVISION, TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.DATE, TextGridObjectTableViewer.Column.OWNER));
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd1 = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gd1);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)RevisionSelectDialog.this.viewer.getSelection();
                RevisionSelectDialog.this.selObj = sel.getFirstElement();
                RevisionSelectDialog.this.buttonOK.setEnabled(true);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)RevisionSelectDialog.this.viewer.getSelection();
                RevisionSelectDialog.this.selObj = sel.getFirstElement();
                RevisionSelectDialog.this.okPressed();
            }
        });
        return area;
    }

    public void refreshDialog(Object obj) {
        this.objTest = obj;
        if (obj instanceof Aggregation) {
            this.setTgo(((Aggregation)obj).getObject());
        } else if (obj instanceof TGOentry) {
            this.setTgo(((TGOentry)obj).getTgo());
        }
        final SearchRequest searchRequest = new SearchRequest();
        UIJob job = new UIJob(Messages.RevisionSelectDialog_RetrieveRevisions){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    progress.beginTask(NLS.bind((String)Messages.RevisionSelectDialog_QueryingRevisions, (Object)RevisionSelectDialog.this.tgo.getTitle()), 100);
                    searchRequest.setQueryRevision(RevisionSelectDialog.this.getTgo().getURI().toString());
                    RevisionSelectDialog.this.viewer.setInput((Object)searchRequest);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Activator.handleError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.buttonOK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.buttonOK.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        super.okPressed();
        if (this.selObj instanceof TextGridObject) {
            if (this.objTest instanceof Aggregation) {
                ((Aggregation)this.objTest).setRevision((TextGridObject)this.selObj);
                ((Aggregation)this.objTest).setLatest(false);
            } else if (this.objTest instanceof TGOentry) {
                ((TGOentry)this.objTest).setRevision((TextGridObject)this.selObj);
                ((TGOentry)this.objTest).setLatest(false);
            }
        }
    }

    protected Point getInitialSize() {
        return new Point(800, 400);
    }

    public TextGridObject getTgo() {
        return this.tgo;
    }

    public void setTgo(TextGridObject tgo) {
        this.tgo = tgo;
    }
}

