/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractRequest
extends Job {
    protected final String query;
    protected final String field;
    private final List<String> currentResults = Collections.synchronizedList(new LinkedList());

    public AbstractRequest(String field, String query) {
        super(NLS.bind((String)"Searching completions for {0} in {1} ...", (Object)query, (Object)field));
        this.field = field;
        this.query = query;
        Assert.isNotNull((Object)field);
        Assert.isNotNull((Object)query);
        Assert.isLegal((!"".equals(field) ? 1 : 0) != 0, (String)"Cannot search in an empty search field");
        Assert.isLegal((!"".equals(query) ? 1 : 0) != 0, (String)"Cannot search completions for the empty string");
    }

    public boolean isApplicableFor(String query) {
        return query.contains(this.query);
    }

    public Iterable<String> getResultsFor(final String query) {
        Iterable result = Iterables.filter(this.currentResults, (Predicate)new Predicate<String>(){

            public boolean apply(String result) {
                if (query != null) {
                    return result.toLowerCase().contains(query.toLowerCase());
                }
                return result.contains(query);
            }
        });
        return result;
    }

    protected void addProposal(String proposal) {
        this.currentResults.add(proposal);
    }

    protected void addAllProposals(Collection<String> proposals) {
        this.currentResults.addAll(proposals);
    }

    protected abstract IStatus run(IProgressMonitor var1);
}

