/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search;

import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.ChunkingElementCollector;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.search.Activator;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.ResultType;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class ProjectListAdapter
implements IDeferredWorkbenchAdapter {
    private TextGridProject project;

    public ProjectListAdapter(TextGridProject adaptableObject) {
        this.project = adaptableObject;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        ChunkingElementCollector groupingCollector = new ChunkingElementCollector(collector, 16);
        monitor.beginTask("Fetching objects in " + this.project, -1);
        SearchRequest searchRequest = new SearchRequest();
        Response response = searchRequest.listProject(this.project.getId());
        if (response != null) {
            for (Object obj : response.getResult()) {
                Status status;
                if (!(obj instanceof ResultType)) continue;
                ObjectType oType = ((ResultType)obj).getObject();
                try {
                    if (oType.getGeneric().getProvided() != null) {
                        TextGridObject tgo = TextGridObject.getInstance((ObjectType)oType, (boolean)true, (boolean)true);
                        TGObjectReference tgoRef = new TGObjectReference(tgo.getLatestURI(), tgo);
                        TextGridObject.addLatestRegistryItem((URI)new URI(tgo.getLatestURI()), (URI)tgo.getURI());
                        TGObjectReference.notifyListeners((TGObjectReference.ITGObjectReferenceListener.Event)TGObjectReference.ITGObjectReferenceListener.Event.NAVIGATOR_OBJECT_CREATED, (TGObjectReference)tgoRef);
                        groupingCollector.add((Object)tgoRef, monitor);
                        continue;
                    }
                    RestrictedTextGridObject rtgo = new RestrictedTextGridObject(oType.getGeneric().getGenerated().getTextgridUri().getValue());
                    groupingCollector.add((Object)rtgo, monitor);
                }
                catch (CoreException e) {
                    status = new Status(4, "info.textgrid.lab.search", NLS.bind((String)"Error while retrieving the objects of project {0}", (Object)this.project.getName()), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
                catch (URISyntaxException e) {
                    status = new Status(4, "info.textgrid.lab.search", NLS.bind((String)"Error on creating URI of the latest revision of {0}", (Object)oType), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
        }
        groupingCollector.done();
        monitor.done();
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return this.project.toString();
    }

    public Object getParent(Object o) {
        return null;
    }
}

