/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import info.textgrid.lab.core.model.IChildListChangedListener;
import info.textgrid.lab.core.model.IChildListParent;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.navigator.NaviExpandedElements;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.UIJob;

public class DeferredTreeContentProvider
implements ITreeContentProvider,
IChildListChangedListener {
    private static final Object[] NO_CHILDREN = new Object[0];
    private DeferredTreeContentManager manager;
    private Viewer viewer;
    private IChildListParent input;
    private static ListenerList doneListeners = new ListenerList();

    public Object[] getChildren(Object parentElement) {
        Object[] managerResults = null;
        if (this.manager != null) {
            managerResults = this.manager.getChildren(parentElement);
        }
        if (managerResults != null) {
            return managerResults;
        }
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)AdapterUtils.getAdapter((Object)parentElement, IWorkbenchAdapter.class);
        if (workbenchAdapter != null) {
            return workbenchAdapter.getChildren(parentElement);
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)AdapterUtils.getAdapter((Object)element, IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.manager.mayHaveChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        if (this.input != null) {
            this.input.removeChildListChangedListener((IChildListChangedListener)this);
        }
    }

    public void cancel(Object input) {
        if (this.manager != null) {
            this.manager.cancel(input);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.input != newInput && newInput instanceof IChildListParent) {
            if (this.input != null) {
                this.input.removeChildListChangedListener((IChildListChangedListener)this);
            }
            this.input = (IChildListParent)newInput;
            this.input.addChildListChangedListener((IChildListChangedListener)this);
        }
        if (viewer instanceof AbstractTreeViewer && this.manager == null) {
            this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
        }
        this.manager.addUpdateCompleteListener(this.getCompletionJobListener());
    }

    public void childListChanged(IChildListParent parent) {
        if (this.viewer != null) {
            this.viewer.setInput((Object)parent);
        }
    }

    protected IJobChangeListener getCompletionJobListener() {
        return new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    DeferredTreeContentProvider.notifyListeners();
                    NaviExpandedElements exElements = NaviExpandedElements.getInstance();
                    TreePath[] actualExTreePaths = exElements.getExpandedTreePaths();
                    if (actualExTreePaths != null && actualExTreePaths.length > 0) {
                        TreePath[] treePathArray = actualExTreePaths;
                        int n = actualExTreePaths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreePath element = treePathArray[n2];
                            int i = 0;
                            while (i <= element.getSegmentCount() - 1) {
                                Object obj = element.getSegment(i);
                                if (obj instanceof TGObjectReference) {
                                    if (!((AbstractTreeViewer)DeferredTreeContentProvider.this.viewer).getExpandedState(obj)) {
                                        ((AbstractTreeViewer)DeferredTreeContentProvider.this.viewer).setExpandedState(obj, true);
                                    }
                                } else if (obj instanceof TextGridProject && !exElements.isDemandedProject((TextGridProject)obj)) {
                                    exElements.addDemandedProject((TextGridProject)obj);
                                    ((AbstractTreeViewer)DeferredTreeContentProvider.this.viewer).setExpandedState(obj, true);
                                }
                                ++i;
                            }
                            ++n2;
                        }
                    }
                }
            }
        };
    }

    public static void addListener(IDeferredTreeListener listener) {
        doneListeners.add((Object)listener);
    }

    public static void removeListener(IDeferredTreeListener listener) {
        doneListeners.remove((Object)listener);
    }

    public static void notifyListeners() {
        UIJob job = new UIJob("Notifying DeferredTreeContent listeners"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = doneListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((IDeferredTreeListener)listener).deferredTreeDone();
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public static interface IDeferredTreeListener {
        public void deferredTreeDone();
    }
}

