/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import info.textgrid.lab.core.model.IChildListChangedListener;
import info.textgrid.lab.core.model.IChildListParent;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.search.TextGridRepositoryItem;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class TextGridRepositoryContentProvider
implements ITreeContentProvider,
IChildListChangedListener {
    private static final Object[] NO_CHILDREN = new Object[0];
    private DeferredTreeContentManager manager;
    private Viewer viewer;
    private IChildListParent input;
    private TextGridRepositoryItem repositroryItem = new TextGridRepositoryItem();

    public Object[] getChildren(Object parentElement) {
        Object[] managerResults = null;
        if (parentElement instanceof TextGridProjectRoot) {
            Object[] returnValue = new Object[]{this.repositroryItem};
            return returnValue;
        }
        if (this.manager != null) {
            managerResults = this.manager.getChildren(parentElement);
        }
        if (managerResults != null) {
            return managerResults;
        }
        IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)AdapterUtils.getAdapter((Object)parentElement, IWorkbenchAdapter.class);
        if (workbenchAdapter != null) {
            return workbenchAdapter.getChildren(parentElement);
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)AdapterUtils.getAdapter((Object)element, IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TextGridRepositoryItem) {
            return true;
        }
        return this.manager.mayHaveChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        if (this.input != null) {
            this.input.removeChildListChangedListener((IChildListChangedListener)this);
        }
    }

    public void cancel(Object input) {
        if (this.manager != null) {
            this.manager.cancel(input);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (viewer instanceof AbstractTreeViewer && this.manager == null) {
            this.manager = new DeferredTreeContentManager((AbstractTreeViewer)viewer);
        }
    }

    public void childListChanged(IChildListParent parent) {
        if (this.viewer != null) {
            this.viewer.setInput((Object)parent);
        }
    }

    public static interface IDeferredTreeListener {
        public void deferredTreeDone();
    }
}

