/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator.filters;

import info.textgrid.lab.navigator.Activator;
import info.textgrid.lab.navigator.NaviExpandedElements;
import info.textgrid.lab.navigator.NaviView;
import info.textgrid.lab.navigator.filters.ContentFilter;
import info.textgrid.lab.navigator.filters.ContentTypeFilterContentProvider;
import info.textgrid.lab.navigator.filters.ContentTypeFilterData;
import info.textgrid.lab.navigator.filters.Messages;
import info.textgrid.lab.navigator.filters.ProjectFilter;
import info.textgrid.lab.navigator.filters.ProjectFilterConentProvider;
import info.textgrid.lab.navigator.filters.ProjectFilterData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class FilterDialog
extends TrayDialog {
    public static final String FILTER_PROJECT_ID = "info.textgrid.lab.navigator.filters.projectfilter";
    public static final String FILTER_CONTENT_ID = "info.textgrid.lab.navigator.filters.contentfilter";
    ContainerCheckedTreeViewer projectFilterTree;
    ContainerCheckedTreeViewer contentFilterTree;

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.FilterDialog_NavigatorFilters);
    }

    protected FilterDialog(Shell shell) {
        super(shell);
    }

    public static void openFilterDialog() {
        FilterDialog d = new FilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        d.open();
    }

    protected Control createDialogArea(Composite parent) {
        int n;
        Group projectGroup = new Group(parent, 2048);
        projectGroup.setText(Messages.FilterDialog_ProjectFilter);
        GridLayout gl = new GridLayout(1, false);
        projectGroup.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        projectGroup.setLayoutData((Object)gd);
        this.projectFilterTree = new ContainerCheckedTreeViewer((Composite)projectGroup);
        this.projectFilterTree.setSorter(new ViewerSorter());
        this.projectFilterTree.setContentProvider((IContentProvider)new ProjectFilterConentProvider());
        this.projectFilterTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.projectFilterTree.setInput((Object)ProjectFilterData.getInstance());
        this.projectFilterTree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.projectFilterTree.expandAll();
        Group contentGroup = new Group(parent, 2048);
        contentGroup.setText(Messages.FilterDialog_ContentFilter);
        contentGroup.setLayout((Layout)gl);
        GridData gdContent = new GridData(4, 4, true, true);
        contentGroup.setLayoutData((Object)gdContent);
        this.contentFilterTree = new ContainerCheckedTreeViewer((Composite)contentGroup);
        this.contentFilterTree.setSorter(new ViewerSorter());
        this.contentFilterTree.setContentProvider((IContentProvider)new ContentTypeFilterContentProvider());
        this.contentFilterTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.contentFilterTree.setInput((Object)ContentTypeFilterData.getInstance());
        this.contentFilterTree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.contentFilterTree.expandAll();
        String projectFilter = Activator.getPreference("filterProject");
        if (projectFilter.equals("")) {
            this.projectFilterTree.setChecked((Object)ProjectFilterData.getInstance().getChildren()[0], true);
        } else {
            String[] stringArray = projectFilter.split(" ");
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String itemRole = stringArray[n2];
                ProjectFilterData item = ProjectFilterData.getItem(itemRole);
                if (item != null) {
                    this.projectFilterTree.setChecked((Object)item, true);
                }
                ++n2;
            }
        }
        String contentTypeFilter = Activator.getPreference("filterContentType");
        if (contentTypeFilter.equals("")) {
            this.contentFilterTree.setChecked((Object)ContentTypeFilterData.getInstance().getChildren()[0], true);
        } else {
            String[] stringArray = contentTypeFilter.split(" ");
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String itemFormat = stringArray[n];
                ContentTypeFilterData item = ContentTypeFilterData.getItem(itemFormat);
                if (item != null) {
                    this.contentFilterTree.setChecked((Object)item, true);
                }
                ++n;
            }
        }
        return parent;
    }

    protected void okPressed() {
        TreePath[] treePath = NaviExpandedElements.getInstance().getExpandedTreePaths();
        String pFilter = this.getProjectFilterString();
        if (pFilter.equals("")) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.FilterDialog_NoValidInput, (String)Messages.FilterDialog_IM_NoRoleSelected);
            return;
        }
        if (this.projectFilterTree.getChecked((Object)ProjectFilterData.getInstance().getChildren()[0])) {
            if (pFilter.equals("*ALL")) {
                this.setFilter(FILTER_PROJECT_ID, false);
                Activator.setPreference("filterProject", "");
            } else {
                this.setFilter(FILTER_PROJECT_ID, true);
                Activator.setPreference("filterProject", pFilter);
            }
        } else {
            this.setFilter(FILTER_PROJECT_ID, false);
            Activator.setPreference("filterProject", "");
        }
        String cFilter = this.getContentTypeFilterString();
        if (cFilter.equals("")) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.FilterDialog_NoValidInput, (String)Messages.FilterDialog_IM_NoContentTypeSelected);
            return;
        }
        if (this.contentFilterTree.getChecked((Object)ContentTypeFilterData.getInstance().getChildren()[0])) {
            if (cFilter.equals("*ALL")) {
                this.setFilter(FILTER_CONTENT_ID, false);
                Activator.setPreference("filterContentType", "");
            } else {
                this.setFilter(FILTER_CONTENT_ID, true);
                Activator.setPreference("filterContentType", cFilter);
            }
        } else {
            this.setFilter(FILTER_CONTENT_ID, false);
            Activator.setPreference("filterContentType", "");
        }
        this.close();
        NaviExpandedElements.getInstance().setExpandedTreePaths(treePath);
        NaviView.refreshNavigator();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements("info.textgrid.lab.navigator.openfilterdialog", null);
    }

    private void setFilter(String filterID, boolean active) {
        block7: {
            ViewerFilter filter;
            int n;
            int n2;
            ViewerFilter[] viewerFilterArray;
            block5: {
                block6: {
                    if (active) {
                        viewerFilterArray = NaviView.getViewer().getFilters();
                        n2 = viewerFilterArray.length;
                        n = 0;
                        while (n < n2) {
                            filter = viewerFilterArray[n];
                            if (filter.toString().toLowerCase().contains(filterID)) {
                                return;
                            }
                            ++n;
                        }
                    }
                    if (!active) break block5;
                    if (!filterID.equals(FILTER_CONTENT_ID)) break block6;
                    NaviView.getViewer().addFilter((ViewerFilter)new ContentFilter(null));
                    break block7;
                }
                if (!filterID.equals(FILTER_PROJECT_ID)) break block7;
                NaviView.getViewer().addFilter((ViewerFilter)new ProjectFilter(null));
                break block7;
            }
            viewerFilterArray = NaviView.getViewer().getFilters();
            n2 = viewerFilterArray.length;
            n = 0;
            while (n < n2) {
                filter = viewerFilterArray[n];
                if (filter.toString().toLowerCase().contains(filterID)) {
                    NaviView.getViewer().removeFilter(filter);
                }
                ++n;
            }
        }
    }

    private String getContentTypeFilterString() {
        String type = "";
        if (this.contentFilterTree.getCheckedElements().length != ContentTypeFilterData.getChildCount()) {
            Object[] objectArray = this.contentFilterTree.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof ContentTypeFilterData && !item.toString().equals(Messages.FilterDialog_ContentTypes)) {
                    type = String.valueOf(type) + ((ContentTypeFilterData)item).getFormat() + " ";
                }
                ++n2;
            }
        } else {
            return "*ALL";
        }
        return type.trim();
    }

    private String getProjectFilterString() {
        String type = "";
        if (this.projectFilterTree.getCheckedElements().length != ProjectFilterData.getChildCount()) {
            Object[] objectArray = this.projectFilterTree.getCheckedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof ProjectFilterData && !item.toString().equals(Messages.FilterDialog_ProjectRoles)) {
                    type = String.valueOf(type) + ((ProjectFilterData)item).getRole() + " ";
                }
                ++n2;
            }
        } else {
            return "*ALL";
        }
        return type.trim();
    }
}

