/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator.filters;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.UserRole2;
import info.textgrid.lab.navigator.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ProjectFilter
extends ViewerFilter {
    ArrayList<String> pArrayList = new ArrayList();

    public ProjectFilter(String filter) {
        if (filter != null && !filter.equals("")) {
            this.pArrayList.clear();
            this.pArrayList.addAll(Arrays.asList(filter.split(" ")));
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("filterProject")) {
                    ProjectFilter.this.pArrayList.clear();
                    ProjectFilter.this.pArrayList.addAll(Arrays.asList(Activator.getPreference("filterProject").split(" ")));
                }
            }
        });
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof TextGridProject) {
            String myEPPN = RBACSession.getInstance().getEPPN().toUpperCase();
            ArrayList userRoles = ((TextGridProject)element).getUserRoles2Offline();
            if (userRoles == null) {
                userRoles = ((TextGridProject)element).getUserRoles2FromRBAC(null);
            }
            for (UserRole2 role : userRoles) {
                if (!role.getePPN().toUpperCase().equals(myEPPN)) continue;
                for (String prole : this.pArrayList) {
                    if (!role.getRoles().contains(prole)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

