/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class LogUtil {
    private String pluginId;
    private int style = 1;

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public LogUtil(String pluginId) {
        this.pluginId = pluginId;
    }

    public IStatus log(int severity, Throwable cause, String message, Object ... arguments) {
        String msg;
        if (message != null) {
            msg = MessageFormat.format(message, arguments);
        } else if (cause != null) {
            msg = cause.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = cause.getClass().getSimpleName();
            }
        } else {
            throw new IllegalArgumentException("You cannot log an error without providing at least an error message or a cause.");
        }
        Object status = cause instanceof CoreException ? new MultiStatus(this.pluginId, 0, new IStatus[]{((CoreException)cause).getStatus()}, msg, cause) : new Status(severity, this.pluginId, msg, cause);
        StatusManager.getManager().handle((IStatus)status, this.style);
        return status;
    }

    public IStatus logError(Throwable e, String message, Object ... arguments) {
        return this.log(4, e, message, arguments);
    }

    public IStatus logError(Throwable e) {
        return this.log(4, e, null, new Object[0]);
    }

    public IStatus log(int severity, String message, Object ... arguments) {
        return this.log(severity, null, message, arguments);
    }

    public IStatus logError(String message, Object ... arguments) {
        return this.log(4, message, arguments);
    }

    public IStatus trace(String message, Object ... arguments) {
        return this.log(1, message, arguments);
    }
}

