/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TitleArea
extends Composite {
    private static final int H_GAP_IMAGE = 5;
    protected Color titleAreaColor;
    private RGB titleAreaRGB;
    private Label titleImageLabel;
    private Image titleAreaImage;
    private Label titleLabel;
    private Label messageImageLabel;
    private Text messageLabel;
    private int messageLabelHeight;
    private Label leftFillerLabel;
    private Label bottomFillerLabel;
    private boolean titleImageLargest;
    private String errorMessage;
    private boolean showingError;
    private String message;
    private Image messageImage;

    public TitleArea(Composite parent, int style) {
        super(parent, style);
        this.createTitleArea();
    }

    private Control createTitleArea() {
        Color foreground;
        Color background;
        TitleArea parent = this;
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TitleArea.this.titleAreaColor != null) {
                    TitleArea.this.titleAreaColor.dispose();
                }
            }
        });
        Display display = parent.getDisplay();
        if (this.titleAreaRGB != null) {
            background = this.titleAreaColor = new Color((Device)display, this.titleAreaRGB);
            foreground = null;
        } else {
            background = JFaceColors.getBannerBackground((Display)display);
            foreground = JFaceColors.getBannerForeground((Display)display);
        }
        parent.setBackground(background);
        int verticalSpacing = 2;
        int horizontalSpacing = 2;
        this.titleImageLabel = new Label((Composite)parent, 0x1000000);
        this.titleImageLabel.setBackground(background);
        if (this.titleAreaImage == null) {
            this.titleImageLabel.setImage(JFaceResources.getImage((String)"dialog_title_banner_image"));
        } else {
            this.titleImageLabel.setImage(this.titleAreaImage);
        }
        FormData imageData = new FormData();
        imageData.top = new FormAttachment(0, 0);
        imageData.right = new FormAttachment(100, 0);
        this.titleImageLabel.setLayoutData((Object)imageData);
        this.titleLabel = new Label((Composite)parent, 16384);
        JFaceColors.setColors((Control)this.titleLabel, (Color)foreground, (Color)background);
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        this.titleLabel.setText(" ");
        FormData titleData = new FormData();
        titleData.top = new FormAttachment(0, verticalSpacing);
        titleData.right = new FormAttachment((Control)this.titleImageLabel);
        titleData.left = new FormAttachment(0, horizontalSpacing);
        this.titleLabel.setLayoutData((Object)titleData);
        this.messageImageLabel = new Label((Composite)parent, 0x1000000);
        this.messageImageLabel.setBackground(background);
        this.messageLabel = new Text((Composite)parent, 72);
        JFaceColors.setColors((Control)this.messageLabel, (Color)foreground, (Color)background);
        this.messageLabel.setText(" \n ");
        this.messageLabel.setFont(JFaceResources.getDialogFont());
        this.messageLabelHeight = this.messageLabel.computeSize((int)-1, (int)-1).y;
        this.leftFillerLabel = new Label((Composite)parent, 0x1000000);
        this.leftFillerLabel.setBackground(background);
        this.bottomFillerLabel = new Label((Composite)parent, 0x1000000);
        this.bottomFillerLabel.setBackground(background);
        this.setLayoutsForNormalMessage(verticalSpacing, horizontalSpacing);
        this.determineTitleImageLargest();
        if (this.titleImageLargest) {
            return this.titleImageLabel;
        }
        return this.messageLabel;
    }

    private void determineTitleImageLargest() {
        int titleY = this.titleImageLabel.computeSize((int)-1, (int)-1).y;
        int verticalSpacing = 2;
        int labelY = this.titleLabel.computeSize((int)-1, (int)-1).y;
        labelY += verticalSpacing;
        labelY += this.messageLabelHeight;
        this.titleImageLargest = titleY > (labelY += verticalSpacing);
    }

    private void setLayoutsForNormalMessage(int verticalSpacing, int horizontalSpacing) {
        FormData messageImageData = new FormData();
        messageImageData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageImageData.left = new FormAttachment(0, 5);
        this.messageImageLabel.setLayoutData((Object)messageImageData);
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, verticalSpacing);
        messageLabelData.right = new FormAttachment((Control)this.titleImageLabel);
        messageLabelData.left = new FormAttachment((Control)this.messageImageLabel, horizontalSpacing);
        messageLabelData.height = this.messageLabelHeight;
        if (this.titleImageLargest) {
            messageLabelData.bottom = new FormAttachment((Control)this.titleImageLabel, 0, 1024);
        }
        this.messageLabel.setLayoutData((Object)messageLabelData);
        FormData fillerData = new FormData();
        fillerData.left = new FormAttachment(0, horizontalSpacing);
        fillerData.top = new FormAttachment((Control)this.messageImageLabel, 0);
        fillerData.bottom = new FormAttachment((Control)this.messageLabel, 0, 1024);
        this.bottomFillerLabel.setLayoutData((Object)fillerData);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.messageImageLabel, 0, 128);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)this.messageImageLabel, 0, 1024);
        data.right = new FormAttachment((Control)this.messageImageLabel, 0);
        this.leftFillerLabel.setLayoutData((Object)data);
    }
}

