/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.log.logsession;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.MetadataTransformer;
import info.textgrid.lab.workflow.servicedescription.Configparameter;
import info.textgrid.lab.workflow.servicedescription.Input;
import info.textgrid.lab.workflow.tgwf.Activities;
import info.textgrid.lab.workflow.tgwf.Activity;
import info.textgrid.lab.workflow.tgwf.CRUD;
import info.textgrid.lab.workflow.tgwf.Configparameters;
import info.textgrid.lab.workflow.tgwf.Datalinks;
import info.textgrid.lab.workflow.tgwf.Inputs;
import info.textgrid.lab.workflow.tgwf.Link;
import info.textgrid.lab.workflow.tgwf.Metadatatransformation;
import info.textgrid.lab.workflow.tgwf.ObjectFactory;
import info.textgrid.lab.workflow.tgwf.Output;
import info.textgrid.lab.workflow.tgwf.Parameter;
import info.textgrid.lab.workflow.tgwf.Service;
import info.textgrid.lab.workflow.tgwf.Tgwf;
import info.textgrid.lab.workflow.tgwf.URI;
import info.textgrid.lab.workflow.tgwf.Xslparam;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.bind.JAXB;
import org.eclipse.core.runtime.CoreException;

public class ChainTGWF {
    private Tgwf t;
    private ObjectFactory tgwfFactory = new ObjectFactory();
    private Chain c;

    public ChainTGWF(Tgwf t) {
        this.t = t;
        Service[] sArr = t.getActivities().getService().toArray(new Service[0]);
        Arrays.sort(sArr, new Comparator<Service>(){

            @Override
            public int compare(Service s1, Service s2) {
                return s1.getId().compareTo(s2.getId());
            }
        });
        ArrayList<ChainEntry> ces = new ArrayList<ChainEntry>();
        Service[] serviceArray = sArr;
        int n = sArr.length;
        int n2 = 0;
        while (n2 < n) {
            Service s = serviceArray[n2];
            try {
                TextGridObject sTGO = TextGridObject.getInstance((java.net.URI)java.net.URI.create(s.getURI()), (boolean)false);
                ChainEntry ce = new ChainEntry(sTGO);
                ce.setID(s.getId().intValue());
                ces.add(ce);
            }
            catch (CrudServiceException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.c = new Chain(ces);
        ArrayList<Link> tmpLinks = new ArrayList<Link>();
        ArrayList<EntryLink> tmpChainLinks = new ArrayList<EntryLink>();
        for (Link l : t.getDatalinks().getLink()) {
            int lInt;
            tmpLinks.add(l);
            info.textgrid.lab.workflow.servicedescription.Output fromPort = null;
            Input toPort = null;
            ChainEntry from = null;
            ChainEntry to = null;
            if (l.getFromServiceID().equals("null")) {
                from = null;
                fromPort = null;
            } else {
                lInt = Integer.parseInt(l.getFromServiceID());
                block5: for (ChainEntry ce : ces) {
                    if (ce.getID() != lInt) continue;
                    from = ce;
                    for (info.textgrid.lab.workflow.servicedescription.Output o : ce.getOutputs()) {
                        if (!o.getParam().equals(l.getFromParam())) continue;
                        fromPort = o;
                        break block5;
                    }
                }
            }
            if (l.getToServiceID().equals("null")) {
                to = null;
                toPort = null;
            } else {
                lInt = Integer.parseInt(l.getToServiceID());
                block7: for (ChainEntry ce : ces) {
                    if (ce.getID() != lInt) continue;
                    to = ce;
                    for (Input i : ce.getInputs()) {
                        if (!i.getParam().equals(l.getToParam())) continue;
                        toPort = i;
                        break block7;
                    }
                }
            }
            EntryLink el = new EntryLink(from, fromPort, to, toPort);
            el.markLinkAdded();
            this.c.getLinks().add(el);
            tmpChainLinks.add(el);
        }
        if (t.getMetadatatransformation() != null && t.getMetadatatransformation().getOutput() != null) {
            for (Output mdto : t.getMetadatatransformation().getOutput()) {
                MetadataTransformer m = new MetadataTransformer();
                int i = 0;
                while (i < tmpLinks.size()) {
                    Link l = (Link)tmpLinks.get(i);
                    if (mdto.getOutputLinkId().equals(l.getId())) {
                        m.setOutput((EntryLink)tmpChainLinks.get(i));
                    }
                    if (mdto.getFromInputLinkId().equals(l.getId())) {
                        m.setFromInput((EntryLink)tmpChainLinks.get(i));
                    }
                    ++i;
                }
                m.setStylesheet(mdto.getStylesheetURI());
                for (Xslparam x : mdto.getXslparam()) {
                    m.getParams().put(x.getName(), x.getValue());
                }
                this.c.getTransformers().add(m);
            }
        } else {
            Activator.handleProblem(2, null, "Either no output (which would be ok), or forgot to specify metadata transformation rules for this workflow.", "x");
        }
        block12: for (Activity a : t.getConfigparameters().getActivity()) {
            for (ChainEntry ce : this.c.getChain()) {
                if (ce.getID() != a.getServiceId().intValue()) continue;
                for (Parameter p : a.getParameter()) {
                    for (Configparameter cp : ce.getConfigParameters()) {
                        if (!cp.getParam().equals(p.getParam())) continue;
                        if (p.getParamId().equals("new_from_String") || p.getParamId().equals("new_from_URI")) {
                            ce.appendNewConfigValue(p.getParam(), p.getParamId().equals("new_from_String"), ChainEntry.anyToString(p.getContent()));
                            continue;
                        }
                        ce.setConfigParam(p.getParam(), p.getParamId());
                    }
                }
                continue block12;
            }
        }
        this.c.setDescription(t.getDescription());
    }

    public Chain getChain() {
        return this.c;
    }

    public void setDescription(String desc) {
        this.t.setDescription(desc);
    }

    public ChainTGWF(Chain c) {
        this.c = c;
        this.t = this.tgwfFactory.createTgwf();
        StringBuffer automaticDescription = new StringBuffer();
        Activities activities = this.tgwfFactory.createActivities();
        Configparameters configParameters = this.tgwfFactory.createConfigparameters();
        for (ChainEntry ce : c.getChain()) {
            automaticDescription.append(ce.getName()).append(" and ");
            Service s = this.tgwfFactory.createService();
            s.setId(BigInteger.valueOf(ce.getID()));
            s.setURI(ce.getTGOURI().toString());
            activities.getService().add(s);
            configParameters.getActivity().add(this.createConfigsForActivity(ce));
        }
        if (c.getDescription().length() > 0) {
            this.t.setDescription(automaticDescription.substring(0, automaticDescription.length() - 5));
        } else {
            this.t.setDescription(c.getDescription());
        }
        this.t.setActivities(activities);
        this.t.setConfigparameters(configParameters);
        Datalinks datalinks = this.tgwfFactory.createDatalinks();
        int linkIdcount = 0;
        for (EntryLink l : c.getLinks()) {
            if (l.isDeleted().booleanValue() || l.isUndecided()) continue;
            ++linkIdcount;
            Link link = this.tgwfFactory.createLink();
            if (l.getFrom() == null || l.getFromPort() == null) {
                link.setFromServiceID("null");
                link.setFromParam("null");
                link.setType("input");
                link.setId("i" + Integer.toString(linkIdcount));
            } else {
                link.setFromServiceID(Integer.toString(l.getFrom().getID()));
                link.setFromParam(l.getFromPort().getParam());
            }
            if (l.getTo() == null || l.getToPort() == null) {
                link.setToServiceID("null");
                link.setToParam("null");
                link.setType("output");
                link.setId("o" + Integer.toString(linkIdcount));
            } else {
                link.setToServiceID(Integer.toString(l.getTo().getID()));
                link.setToParam(l.getToPort().getParam());
            }
            if (link.getType() == null) {
                link.setId(Integer.toString(linkIdcount));
                link.setType("interservice");
            }
            datalinks.getLink().add(link);
        }
        this.t.setDatalinks(datalinks);
    }

    public Activity createConfigsForActivity(ChainEntry ce) {
        Activity a = this.tgwfFactory.createActivity();
        a.setServiceId(BigInteger.valueOf(ce.getID()));
        for (Configparameter cp : ce.getConfigParameters()) {
            int i = 0;
            while (i < ce.getChosenConfigParamExampleValues(cp.getParam()).size()) {
                Parameter p = this.tgwfFactory.createParameter();
                p.setParam(cp.getParam());
                p.setParamId(ce.getChosenConfigParamExampleValues(cp.getParam()).get(i).getId());
                if (p.getParamId().equals("new_from_String") || p.getParamId().equals("new_from_URI")) {
                    ChainEntry.anyToString(ce.getChosenConfigParamExampleValues(cp.getParam()).get(i).getContent());
                    p.getContent().addAll(ce.getChosenConfigParamExampleValues(cp.getParam()).get(i).getContent());
                }
                a.getParameter().add(p);
                ++i;
            }
        }
        return a;
    }

    public void insertCRUD(String targetProject) {
        CRUD c = this.tgwfFactory.createCRUD();
        String crudEpr = "";
        try {
            ConfClient confClient = ConfClient.getInstance();
            crudEpr = confClient.getValue("tgcrud");
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"Could not contact Confserv", (Throwable)e);
        }
        c.setInstance(crudEpr);
        c.setSessionID(RBACSession.getInstance().getSID(false));
        c.setLogParameter(logsession.getInstance().getloginfo());
        c.setTargetProject(targetProject);
        this.t.setCRUD(c);
    }

    public void insertInputURI(EntryLink inputlink, String groupId, java.net.URI uri) {
        if (this.t.getInputs() == null) {
            Inputs i = this.tgwfFactory.createInputs();
            this.t.setInputs(i);
        }
        URI u = this.tgwfFactory.createURI();
        for (Link l : this.t.getDatalinks().getLink()) {
            if (!l.getType().equals("input") || inputlink.getTo().getID() != Integer.valueOf(l.getToServiceID()).intValue() || !inputlink.getToPort().getParam().equals(l.getToParam())) continue;
            u.setLinkId(l.getId());
        }
        u.setGroupId(groupId);
        u.setValue(uri.toString());
        this.t.getInputs().getURI().add(u);
    }

    public void insertMetadataTransformer(EntryLink outputlink, EntryLink inputlink, java.net.URI stylesheet, HashMap<String, String> xslparams) {
        if (this.t.getMetadatatransformation() == null) {
            Metadatatransformation mdt = this.tgwfFactory.createMetadatatransformation();
            this.t.setMetadatatransformation(mdt);
        }
        Output o = this.tgwfFactory.createOutput();
        for (Link l : this.t.getDatalinks().getLink()) {
            if (l.getType().equals("output") && outputlink.getFrom().getID() == Integer.valueOf(l.getFromServiceID()).intValue() && outputlink.getFromPort().getParam().equals(l.getFromParam())) {
                o.setOutputLinkId(l.getId());
            }
            if (!l.getType().equals("input") || inputlink.getTo().getID() != Integer.valueOf(l.getToServiceID()).intValue() || !inputlink.getToPort().getParam().equals(l.getToParam())) continue;
            o.setFromInputLinkId(l.getId());
        }
        o.setStylesheetURI(stylesheet.toString());
        for (String key : xslparams.keySet()) {
            Xslparam x = this.tgwfFactory.createXslparam();
            x.setName(key);
            x.setValue(xslparams.get(key));
            o.getXslparam().add(x);
        }
        this.t.getMetadatatransformation().getOutput().add(o);
    }

    private void encodeB64inlineConfigs() {
        for (Activity a : this.t.getConfigparameters().getActivity()) {
            Iterator<Parameter> iterator = a.getParameter().iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    public Tgwf getTGWF() {
        return this.t;
    }

    public String marshal() {
        this.encodeB64inlineConfigs();
        StringWriter xml = new StringWriter();
        JAXB.marshal((Object)this.t, (Writer)xml);
        return xml.toString();
    }
}

