/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.servicedescription.Input;
import info.textgrid.lab.workflow.servicedescription.Output;

public class EntryLink {
    private ChainEntry from = null;
    private ChainEntry to = null;
    private Output fromPort = null;
    private Input toPort = null;
    private int hashCode = 0;
    private LinkState linkState = LinkState.POSSIBLE;

    public EntryLink(ChainEntry from, Output fromPort, ChainEntry to, Input toPort) {
        this.from = from;
        this.to = to;
        this.fromPort = fromPort;
        this.toPort = toPort;
        this.linkState = LinkState.POSSIBLE;
        this.hashCode = this.hashCode();
    }

    public boolean equals(Object oo) {
        if (oo instanceof EntryLink) {
            EntryLink o = (EntryLink)oo;
            return this.from == o.from && this.to == o.to && this.fromPort == o.fromPort && this.toPort == o.toPort;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int result = 17;
        if (this.from != null && this.fromPort != null) {
            result = 9 * result + this.from.hashCode() + this.fromPort.hashCode();
        }
        if (this.to != null && this.toPort != null) {
            result = 13 * result + this.to.hashCode() + this.toPort.hashCode();
        }
        return result;
    }

    public Boolean isAdded() {
        if (this.linkState == LinkState.ADDED) {
            return true;
        }
        return false;
    }

    public void markLinkAdded() {
        this.linkState = LinkState.ADDED;
    }

    public Boolean isDeleted() {
        if (this.linkState == LinkState.DELETED) {
            return true;
        }
        return false;
    }

    public void markLinkDeleted() {
        this.linkState = LinkState.DELETED;
    }

    public boolean isUndecided() {
        return this.linkState == LinkState.POSSIBLE;
    }

    public void resetState() {
        this.linkState = LinkState.POSSIBLE;
    }

    public Output getFromPort() {
        return this.fromPort;
    }

    public void setFromPort(Output fromPort) {
        this.hashCode = 0;
        this.fromPort = fromPort;
    }

    public Input getToPort() {
        return this.toPort;
    }

    public void setToPort(Input toPort) {
        this.hashCode = 0;
        this.toPort = toPort;
    }

    public ChainEntry getFrom() {
        return this.from;
    }

    public void setFrom(ChainEntry from) {
        this.hashCode = 0;
        this.from = from;
    }

    public ChainEntry getTo() {
        return this.to;
    }

    public void setTo(ChainEntry to) {
        this.hashCode = 0;
        this.to = to;
    }

    public void dump() {
        if (this.linkState == LinkState.POSSIBLE) {
            System.out.println("Possible: From " + this.getFrom() + ", " + (this.getFromPort() == null ? "WF-global Input" : this.getFromPort().getName()) + " to " + this.getTo() + ", " + (this.getToPort() == null ? "WF-global Output" : this.getToPort().getName()));
        } else if (this.linkState == LinkState.ADDED) {
            System.out.println("Added: From " + this.getFrom() + ", " + (this.getFromPort() == null ? "WF-global Input" : this.getFromPort().getName()) + " to " + this.getTo() + ", " + (this.getToPort() == null ? "WF-global Output" : this.getToPort().getName()));
        } else {
            System.out.println("Deleted: From " + this.getFrom() + ", " + (this.getFromPort() == null ? "WF-global Input" : this.getFromPort().getName()) + " to " + this.getTo() + ", " + (this.getToPort() == null ? "WF-global Output" : this.getToPort().getName()));
        }
    }

    public static enum LinkState {
        POSSIBLE,
        ADDED,
        DELETED;

    }
}

