/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.MetadataTransformer;
import info.textgrid.lab.workflow.views.MetadataTransformerDialogue;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class MetadataTransformView
extends ViewPart {
    private Composite outerC;
    private Composite fromFields;
    private ArrayList<EntryLink> outputs;
    private ArrayList<ComboViewer> combos;
    private ArrayList<EntryLink> inputs;
    private Chain chain = null;

    public void createPartControl(Composite parent) {
        this.outerC = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        this.outerC.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        this.outerC.setLayout((Layout)glp);
        if (this.chain != null) {
            this.refreshTransformerView(this.chain);
        }
    }

    private void readLinks() {
        this.outputs = new ArrayList();
        this.inputs = new ArrayList();
        for (EntryLink l : this.chain.getLinks()) {
            if (l.isUndecided() || l.isDeleted().booleanValue()) continue;
            if (l.getFrom() == null && l.getFromPort() == null) {
                this.inputs.add(l);
            }
            if (l.getTo() != null || l.getToPort() != null) continue;
            this.outputs.add(l);
        }
    }

    public void refreshTransformerView(Chain c) {
        this.chain = c;
        this.readLinks();
        this.combos = new ArrayList();
        if (this.fromFields != null) {
            this.fromFields.dispose();
        }
        this.fromFields = new Composite(this.outerC, 4);
        this.fromFields.setLayout((Layout)new GridLayout(4, false));
        GridData gd2 = new GridData(4, 2, true, false);
        this.fromFields.setLayoutData((Object)gd2);
        for (EntryLink l : this.outputs) {
            Label outputName = new Label(this.fromFields, 4);
            outputName.setText(String.valueOf(l.getFrom().getName()) + " / " + l.getFromPort().getName());
            Label fromLabel = new Label(this.fromFields, 4);
            fromLabel.setText("generate from");
            ComboViewer cv = new ComboViewer(this.fromFields, 4);
            cv.setLabelProvider((IBaseLabelProvider)new mdtLabelProvider());
            cv.setContentProvider((IContentProvider)new ArrayContentProvider());
            cv.setInput(this.inputs);
            if (this.inputs.size() == 1) {
                cv.setSelection((ISelection)new StructuredSelection((Object)this.inputs.get(0)), true);
            }
            this.combos.add(cv);
            MetadataTransformer myMDT = null;
            for (MetadataTransformer mdt : this.chain.getTransformers()) {
                if (!mdt.getOutput().equals(l) || !this.inputs.contains(mdt.getFromInput())) continue;
                myMDT = mdt;
                cv.setSelection((ISelection)new StructuredSelection((Object)mdt.getFromInput()), true);
            }
            if (myMDT == null) {
                myMDT = new MetadataTransformer();
                myMDT.setOutput(l);
                myMDT.setDefaultParams();
                this.chain.getTransformers().add(myMDT);
            }
            final int myMDTindex = this.chain.getTransformers().indexOf(myMDT);
            Button configureButton = new Button(this.fromFields, 8);
            configureButton.setText("Configure...");
            configureButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    MetadataTransformerDialogue mdtd = new MetadataTransformerDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                    mdtd.setContents(MetadataTransformView.this.chain.getTransformers().get(myMDTindex));
                    mdtd.setBlockOnOpen(true);
                    mdtd.open();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.outerC.layout(true, true);
    }

    public void setFromInputs() {
        Iterator<EntryLink> oIt = this.outputs.iterator();
        for (ComboViewer cv : this.combos) {
            EntryLink outputLink = oIt.next();
            IStructuredSelection spss = (IStructuredSelection)cv.getSelection();
            EntryLink inputLink = null;
            if (spss.getFirstElement() instanceof EntryLink) {
                inputLink = (EntryLink)spss.getFirstElement();
                if (inputLink != null) {
                    for (MetadataTransformer mdt : this.chain.getTransformers()) {
                        if (!mdt.getOutput().equals(outputLink)) continue;
                        mdt.setFromInput(inputLink);
                        System.out.println("Metadata for " + outputLink.getFromPort().getName() + " will be generated from " + inputLink.getToPort().getName());
                    }
                    continue;
                }
                System.out.println("B\u00e4\u00e4\u00e4h");
                continue;
            }
            System.out.println("B\u00e4\u00e4\u00e4h\u00b2");
        }
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.fromFields.getShell(), (String)"Service List", (String)message);
    }

    public void setFocus() {
        this.outerC.setFocus();
    }

    public void dispose() {
    }

    class mdtLabelProvider
    extends LabelProvider {
        mdtLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof EntryLink) {
                EntryLink l = (EntryLink)obj;
                return String.valueOf(l.getTo().getName()) + "/" + l.getToPort().getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }
}

