/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.wizard;

import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.EntryLinkFromComparator;
import info.textgrid.lab.workflow.servicedescription.Configparameter;
import info.textgrid.lab.workflow.servicedescription.Examplevalue;
import info.textgrid.lab.workflow.views.ConfigParameterEditingDialogue;
import info.textgrid.lab.workflow.wizard.Messages;
import info.textgrid.lab.workflow.wizard.MetadataTransformationPage;
import info.textgrid.lab.workflow.wizard.WorkflowWizard;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ServiceConfigurationPage
extends WizardPage
implements Listener {
    Chain chain;
    Composite composite;
    ScrolledComposite scrolledcomposite;

    public ServiceConfigurationPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ServiceConfigurationPage_pagetitle);
        this.setDescription(Messages.ServiceConfigurationPage_pagedescription);
    }

    public void createControl(Composite parent) {
        this.chain = ((WorkflowWizard)this.getWizard()).getChain();
        GridData parentGD = new GridData();
        parentGD.horizontalAlignment = 4;
        parentGD.grabExcessVerticalSpace = true;
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.heightHint = 400;
        parentGD.widthHint = 800;
        parentGD.verticalAlignment = 4;
        parent.setLayoutData((Object)parentGD);
        this.scrolledcomposite = new ScrolledComposite(parent, 768);
        this.scrolledcomposite.setAlwaysShowScrollBars(true);
        this.composite = new Composite((Composite)this.scrolledcomposite, 2048);
        GridLayout glstd = new GridLayout(1, false);
        this.composite.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gdstd);
        this.scrolledcomposite.setContent((Control)this.composite);
        this.scrolledcomposite.setExpandVertical(true);
        this.scrolledcomposite.setExpandHorizontal(true);
        this.scrolledcomposite.setMinWidth(775);
        this.scrolledcomposite.setMinHeight(300 * this.chain.getChain().size());
        this.setControl((Control)this.scrolledcomposite);
        this.drawCEboxes();
    }

    public void drawCEboxes() {
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        for (ChainEntry ce : this.chain.getChain()) {
            this.drawCEbox(ce);
        }
        this.scrolledcomposite.setMinHeight(200 * this.chain.getChain().size());
        this.scrolledcomposite.layout(true, true);
    }

    public void drawCEbox(ChainEntry ce) {
        Composite comp = new Composite(this.composite, 2048);
        GridLayout glstd = new GridLayout(1, false);
        comp.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, false);
        comp.setLayoutData((Object)gdstd);
        this.drawName(ce, comp);
        this.drawConfigParams(ce, comp);
    }

    public void drawName(ChainEntry e, Composite comp) {
        Composite nameBar = new Composite(comp, 0);
        GridLayout glstd = new GridLayout(2, false);
        glstd.horizontalSpacing = 20;
        nameBar.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, false);
        nameBar.setLayoutData((Object)gdstd);
        Label labelName = new Label(nameBar, 4);
        labelName.setText(e.getName());
        GridData gd3aI = new GridData(16384, 0x1000000, false, false);
        labelName.setLayoutData((Object)gd3aI);
        if (e.getConfigParameters().size() == 0) {
            Label labelNoConfigParams = new Label(nameBar, 4);
            labelNoConfigParams.setText(Messages.ServiceConfigurationPage_serviceHasNoParamsLabel);
            GridData gd3ancp = new GridData(16384, 0x1000000, false, false);
            labelNoConfigParams.setLayoutData((Object)gd3ancp);
        }
    }

    public void drawConfigParams(ChainEntry e, Composite comp) {
        Composite paramBar = new Composite(comp, 0);
        GridLayout glstd = new GridLayout(1, false);
        paramBar.setLayout((Layout)glstd);
        GridData gdstd = new GridData(4, 4, true, true);
        paramBar.setLayoutData((Object)gdstd);
        final ChainEntry currentChainEntry = e;
        for (Configparameter cp : e.getConfigParameters()) {
            Composite c = new Composite(paramBar, 0);
            final String thisConfigParam = cp.getParam();
            final String thisConfigParamName = cp.getName();
            c.setLayout((Layout)new GridLayout(cp.isMultiple() != false ? 6 : 4, false));
            GridData gdc = new GridData(4, 4, false, false);
            c.setLayoutData((Object)gdc);
            ArrayList<Examplevalue> exValues = e.getChosenConfigParamExampleValues(cp.getParam());
            if (exValues.size() == 0) {
                Label t = new Label(c, 4);
                t.setText(String.valueOf(cp.getName()) + Messages.ServiceConfigurationPage_noValuesSetLabel);
                GridData gde = new GridData(4, 4, false, false);
                t.setLayoutData((Object)gde);
                Button addB = new Button(c, 8);
                GridData gdb = new GridData(4, 4, false, false);
                addB.setLayoutData((Object)gdb);
                addB.setText(Messages.ServiceConfigurationPage_AddMenu);
                addB.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        currentChainEntry.addDefaultExampleValue(thisConfigParam);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                break;
            }
            int i = 0;
            while (i < exValues.size()) {
                GridData gde;
                final int exValueCounter = i;
                if (i == 0) {
                    Label t = new Label(c, 4);
                    t.setText(String.valueOf(cp.getName()) + ": ");
                    gde = new GridData(4, 4, false, false);
                    t.setLayoutData((Object)gde);
                } else {
                    Label dummy = new Label(c, 4);
                    dummy.setText("");
                    gde = new GridData(4, 4, false, false);
                    dummy.setLayoutData((Object)gde);
                }
                final ComboViewer cv = new ComboViewer(c, 4);
                cv.setLabelProvider((IBaseLabelProvider)new ConfigLabelProvider());
                cv.setContentProvider((IContentProvider)new ArrayContentProvider());
                cv.setComparator((ViewerComparator)new EntryLinkFromComparator());
                cv.setInput(cp.getExamplevalue());
                GridData gdcv = new GridData(4, 4, false, false);
                cv.getControl().setLayoutData((Object)gdcv);
                if (exValues.get(i).isDefault()) {
                    cv.setSelection((ISelection)new StructuredSelection((Object)exValues.get(i)), true);
                    currentChainEntry.selectExampleValue(thisConfigParam, exValues.get(i), i);
                }
                cv.addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection spss = (IStructuredSelection)cv.getSelection();
                        Examplevalue selectedID = null;
                        if (spss.getFirstElement() instanceof Examplevalue && (selectedID = (Examplevalue)spss.getFirstElement()) != null) {
                            currentChainEntry.selectExampleValue(thisConfigParam, selectedID, exValueCounter);
                        }
                    }
                });
                Button editB = new Button(c, 8);
                editB.setText(Messages.ServiceConfigurationPage_editmenu);
                GridData gdeb = new GridData(4, 4, false, false);
                editB.setLayoutData((Object)gdeb);
                if (cp.isMultiple().booleanValue()) {
                    Button addB = new Button(c, 8);
                    GridData gdab = new GridData(4, 4, false, false);
                    addB.setLayoutData((Object)gdab);
                    addB.setText(Messages.ServiceConfigurationPage_addmenu);
                    addB.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent event) {
                            currentChainEntry.addDefaultExampleValue(thisConfigParam);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                    Button delB = new Button(c, 8);
                    GridData gddb = new GridData(4, 4, false, false);
                    delB.setLayoutData((Object)gddb);
                    delB.setText(Messages.ServiceConfigurationPage_deletemenu);
                    delB.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent event) {
                            currentChainEntry.deleteExampleValue(thisConfigParam, exValueCounter);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                editB.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent event) {
                        Examplevalue selectedExValue = currentChainEntry.getChosenConfigParamExampleValues(thisConfigParam).get(exValueCounter);
                        IStructuredSelection spss = (IStructuredSelection)cv.getSelection();
                        if (spss.getFirstElement() instanceof Examplevalue) {
                            selectedExValue = (Examplevalue)spss.getFirstElement();
                        }
                        String orig = ChainEntry.anyToString(selectedExValue.getContent());
                        ConfigParameterEditingDialogue cped = new ConfigParameterEditingDialogue(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        cped.setContents(thisConfigParamName, orig, currentChainEntry, thisConfigParam, selectedExValue.isInline(), exValueCounter);
                        cped.setBlockOnOpen(true);
                        cped.open();
                        cv.setInput(currentChainEntry.getAllAvailableExampleValues(thisConfigParam));
                        cv.setSelection((ISelection)new StructuredSelection((Object)currentChainEntry.getChosenConfigParamExampleValues(thisConfigParam).get(exValueCounter)), true);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                ++i;
            }
        }
        comp.layout(true, true);
    }

    public void handleEvent(Event event) {
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public boolean isPageComplete() {
        return true;
    }

    public void dumpAllConfigs() {
        System.out.println("DDDDDDDDDDDDDDDDDDDDumping:");
        for (ChainEntry e : this.chain.getChain()) {
            System.out.println(e.getName());
            for (Configparameter cp : e.getConfigParameters()) {
                System.out.println(String.valueOf(cp.getName()) + ":");
                for (Examplevalue ex : e.getChosenConfigParamExampleValues(cp.getParam())) {
                    System.out.println(ChainEntry.anyToString(ex.getContent()));
                }
            }
        }
    }

    public IWizardPage getNextPage() {
        MetadataTransformationPage md = ((WorkflowWizard)this.getWizard()).metadataTransformation;
        md.refreshTransformerArea();
        return md;
    }

    class ConfigLabelProvider
    extends LabelProvider {
        ConfigLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof Examplevalue) {
                Examplevalue ex = (Examplevalue)obj;
                return ex.getName();
            }
            return "unknown class: " + obj.getClass();
        }
    }
}

