/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.wizard;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.wizard.LinkInsertionPage;
import info.textgrid.lab.workflow.wizard.Messages;
import info.textgrid.lab.workflow.wizard.ServiceSelectionPage;
import info.textgrid.lab.workflow.wizard.WorkflowWizard;
import java.net.URI;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ServiceOrderingPage
extends WizardPage
implements Listener {
    private Chain chain;
    private TableViewer orderViewer;

    public ServiceOrderingPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ServiceOrderingPage_pagetitle);
        this.setDescription(Messages.ServiceOrderingPage_pagedescription);
    }

    public void createControl(Composite parent) {
        GridData parentGD = new GridData();
        parentGD.horizontalAlignment = 4;
        parentGD.grabExcessVerticalSpace = true;
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.heightHint = 400;
        parentGD.widthHint = 800;
        parentGD.verticalAlignment = 4;
        parent.setLayoutData((Object)parentGD);
        Composite composite = new Composite(parent, 0);
        GridData gdstd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gdstd);
        GridLayout glstd = new GridLayout(2, false);
        composite.setLayout((Layout)glstd);
        this.setControl((Control)composite);
        this.orderViewer = new TableViewer(composite, 66308);
        this.orderViewer.getTable().setHeaderVisible(false);
        this.orderViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.orderViewer.setLabelProvider((IBaseLabelProvider)new OrderServicesLabelProvider());
        GridData gd0 = new GridData(4, 4, true, true);
        this.orderViewer.getControl().setLayoutData((Object)gd0);
        this.chain = ((WorkflowWizard)this.getWizard()).getChain();
        this.refreshViewer();
        Composite arrowComposite = new Composite(composite, 0);
        GridData gdstda = new GridData(4, 4, true, true);
        arrowComposite.setLayoutData((Object)gdstda);
        GridLayout glstda = new GridLayout(1, false);
        arrowComposite.setLayout((Layout)glstda);
        Button moveUpButton = new Button(arrowComposite, 8);
        moveUpButton.setText(Messages.ServiceOrderingPage_MoveUpButton);
        moveUpButton.setToolTipText(Messages.ServiceOrderingPage_MoveUpButtonTip);
        moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceOrderingPage.this.reorderServices(MoveDirection.UP);
                ServiceOrderingPage.this.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button moveDownButton = new Button(arrowComposite, 8);
        moveDownButton.setText(Messages.ServiceOrderingPage_MoveDownButton);
        moveDownButton.setToolTipText(Messages.ServiceOrderingPage_MoveDownButtonDescription);
        moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceOrderingPage.this.reorderServices(MoveDirection.DOWN);
                ServiceOrderingPage.this.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button duplicateButton = new Button(arrowComposite, 8);
        duplicateButton.setText(Messages.ServiceOrderingPage_DuplicateButton);
        duplicateButton.setToolTipText(Messages.ServiceOrderingPage_DuplicateButtonDescription);
        duplicateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceOrderingPage.this.reorderServices(MoveDirection.DUPLICATE);
                ServiceOrderingPage.this.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button removeButton = new Button(arrowComposite, 8);
        removeButton.setText(Messages.ServiceOrderingPage_RemoveButton);
        removeButton.setToolTipText(Messages.ServiceOrderingPage_RemoveButtonDescription);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceOrderingPage.this.reorderServices(MoveDirection.REMOVE);
                ServiceOrderingPage.this.refreshViewer();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    void reorderServices(MoveDirection direction) {
        IStructuredSelection sel = (IStructuredSelection)this.orderViewer.getSelection();
        if (sel == null) {
            return;
        }
        Object elem = sel.getFirstElement();
        if (elem instanceof ChainEntry) {
            ChainEntry ce = (ChainEntry)elem;
            int oldpos = this.chain.getChain().indexOf(ce);
            if (direction.equals((Object)MoveDirection.UP) && oldpos > 0) {
                this.chain.getChain().remove(oldpos);
                this.chain.getChain().add(oldpos - 1, ce);
            } else if (direction.equals((Object)MoveDirection.DOWN) && oldpos < this.chain.getChain().size() - 1) {
                this.chain.getChain().remove(oldpos);
                this.chain.getChain().add(oldpos + 1, ce);
            } else if (direction.equals((Object)MoveDirection.DUPLICATE)) {
                TextGridObject TGOofce = null;
                try {
                    TGOofce = TextGridObject.getInstance((URI)ce.getTGOURI(), (boolean)false);
                }
                catch (CrudServiceException e) {
                    e.printStackTrace();
                }
                this.chain.addEntry(new ChainEntry(TGOofce));
            } else if (direction.equals((Object)MoveDirection.REMOVE)) {
                this.chain.getChain().remove(oldpos);
            }
            this.chain.resetLinks();
            this.chain.connectEntriesMonotone();
        }
    }

    void refreshViewer() {
        this.orderViewer.setInput(this.chain.getChain());
        this.orderViewer.refresh();
    }

    public void handleEvent(Event event) {
        this.refreshViewer();
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    public boolean isPageComplete() {
        return true;
    }

    public IWizardPage getPreviousPage() {
        ServiceSelectionPage ss = ((WorkflowWizard)this.getWizard()).serviceSelection;
        return ss;
    }

    public IWizardPage getNextPage() {
        LinkInsertionPage li = ((WorkflowWizard)this.getWizard()).linkInsertion;
        li.drawCEboxes();
        return li;
    }

    public static enum MoveDirection {
        UP,
        DOWN,
        DUPLICATE,
        REMOVE;

    }

    class OrderServicesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OrderServicesLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ChainEntry) {
                ChainEntry ce = (ChainEntry)obj;
                return ce.getName();
            }
            return "unknown class: " + obj.getClass();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

