/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.wizard;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.Chain;
import info.textgrid.lab.workflow.ChainEntry;
import info.textgrid.lab.workflow.approvedlist.Approved;
import info.textgrid.lab.workflow.approvedlist.Service;
import info.textgrid.lab.workflow.wizard.Messages;
import info.textgrid.lab.workflow.wizard.ServiceOrderingPage;
import info.textgrid.lab.workflow.wizard.WorkflowWizard;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXB;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class ServiceSelectionPage
extends WizardPage
implements ISelectionChangedListener {
    private TextGridObjectTableViewer allViewer;
    private TableViewer approvedViewer;
    private boolean showSearchResults;
    private Button servicesLockedButton;
    private TabFolder folder;
    private TabItem approvedTab;
    private TabItem allTab;
    public final String APPROVED_LIST_KEY = "ApprovedServicesTextGridURI";
    private List<Service> approvedServices = new ArrayList<Service>();
    private boolean servicesLocked = false;
    private Chain chain;
    ArrayList<TextGridObject> newServices;

    public ServiceSelectionPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.ServiceSelectionPage_pageTitle);
        this.setDescription(Messages.ServiceSelectionPage_PageDescription);
    }

    public void createControl(Composite parent) {
        int ncol;
        this.chain = ((WorkflowWizard)this.getWizard()).getChain();
        GridData parentGD = new GridData();
        parentGD.horizontalAlignment = 4;
        parentGD.grabExcessVerticalSpace = true;
        parentGD.grabExcessHorizontalSpace = true;
        parentGD.heightHint = 400;
        parentGD.widthHint = 800;
        parentGD.verticalAlignment = 4;
        parent.setLayoutData((Object)parentGD);
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = ncol = 1;
        composite.setLayout((Layout)gl);
        this.setControl((Control)composite);
        this.folder = new TabFolder(composite, 128);
        GridData gf = new GridData(4, 4, true, true);
        this.folder.setLayoutData((Object)gf);
        GridLayout glf = new GridLayout(1, false);
        this.folder.setLayout((Layout)glf);
        Composite approvedComposite = new Composite((Composite)this.folder, 0);
        GridData gdstd = new GridData(4, 4, true, true);
        approvedComposite.setLayoutData((Object)gdstd);
        GridLayout glstd = new GridLayout(1, false);
        approvedComposite.setLayout((Layout)glstd);
        this.approvedTab = new TabItem(this.folder, 0);
        this.approvedTab.setText(Messages.ServiceSelectionPage_ApprovedTabTitle);
        this.approvedTab.setControl((Control)approvedComposite);
        Composite allServicesComposite = new Composite((Composite)this.folder, 0);
        GridData gdexp = new GridData(4, 4, true, true);
        allServicesComposite.setLayoutData((Object)gdexp);
        GridLayout glexp = new GridLayout(1, false);
        allServicesComposite.setLayout((Layout)glexp);
        this.allTab = new TabItem(this.folder, 0);
        this.allTab.setText(Messages.ServiceSelectionPage_AllTabTitle);
        this.allTab.setControl((Control)allServicesComposite);
        this.approvedViewer = new TableViewer(approvedComposite, 66306);
        this.approvedViewer.getTable().setHeaderVisible(false);
        this.approvedViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.approvedViewer.setLabelProvider((IBaseLabelProvider)new ApprovedServicesLabelProvider());
        this.approvedViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        GridData gd0 = new GridData(4, 4, true, true);
        this.approvedViewer.getControl().setLayoutData((Object)gd0);
        this.approvedViewer.setSorter((ViewerSorter)new NameSorter());
        boolean foundApproved = this.fillApprovedViewer();
        if (!foundApproved) {
            approvedComposite.dispose();
            this.approvedTab.dispose();
        }
        this.allViewer = new TextGridObjectTableViewer(allServicesComposite, 66306);
        this.allViewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE));
        this.allViewer.getTable().setHeaderVisible(false);
        GridData gd1 = new GridData(4, 4, true, true);
        this.allViewer.getControl().setLayoutData((Object)gd1);
        this.allViewer.setSorter((ViewerSorter)new NameSorter());
        this.allViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ((DeferredListContentProvider)this.allViewer.getContentProvider()).addDoneListener(new DeferredListContentProvider.IDoneListener(){

            public void loadDone(Viewer viewer) {
                ServiceSelectionPage.this.placeSelections(ServiceSelectionPage.this.chain);
            }
        });
        this.refreshViewer();
        this.newServices = new ArrayList();
        this.servicesLockedButton = new Button(composite, 32);
        GridData gd3a = new GridData(16384, 0x1000000, true, false);
        gd3a.widthHint = 2000;
        this.servicesLockedButton.setLayoutData((Object)gd3a);
        this.servicesLockedButton.setText(Messages.ServiceSelectionPage_KeepServicesButtonText);
        this.servicesLockedButton.setToolTipText(Messages.ServiceSelectionPage_KeepServicesButtonDescription);
        this.servicesLockedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceSelectionPage.this.setLockedServices(ServiceSelectionPage.this.servicesLockedButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        if (this.chain.getChain().size() > 0) {
            this.setLockedServices(true);
        }
    }

    void setLockedServices(boolean locked) {
        this.servicesLocked = locked;
        if (!this.approvedViewer.getTable().isDisposed()) {
            this.approvedViewer.getTable().setEnabled(!locked);
        }
        this.allViewer.getTable().setEnabled(!locked);
        this.servicesLockedButton.setSelection(locked);
    }

    private void refreshViewer() {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setAllProjects(true);
        searchRequest.setQueryMetadata("format:\"text/tg.servicedescription+xml\"");
        this.allViewer.setInput((Object)searchRequest);
    }

    private boolean fillApprovedViewer() {
        String approvedURIstring;
        block4: {
            ConfClient confClient = ConfClient.getInstance();
            approvedURIstring = confClient.getValue("ApprovedServicesTextGridURI");
            if (approvedURIstring != null && !approvedURIstring.equals("")) break block4;
            Activator.handleProblem(2, new Throwable(), "Workflow: Could not find TextGridObject holding the approved services list!", new Object[0]);
            return false;
        }
        try {
            URI approvedURI = new URI(approvedURIstring);
            TextGridObject listtgo = TextGridObject.getInstance((URI)approvedURI, (boolean)false);
            IFile sf = (IFile)listtgo.getAdapter(IFile.class);
            Approved approvedlist = (Approved)JAXB.unmarshal((InputStream)sf.getContents(true), Approved.class);
            this.approvedServices = approvedlist.getService();
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"Workflow: Could not contact Confserver for Approved Services List location!", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.approvedViewer.setInput(this.approvedServices);
        return true;
    }

    void placeSelections(Chain c) {
        ArrayList<URI> apprUris = new ArrayList<URI>();
        for (Service s : this.approvedServices) {
            apprUris.add(URI.create(s.getUri()));
        }
        ArrayList<URI> chainUris = new ArrayList<URI>();
        boolean onlyApprovedURIS = true;
        for (ChainEntry ce : c.getChain()) {
            URI u = ce.getTGOURI();
            chainUris.add(u);
            boolean found = false;
            for (URI uRI : apprUris) {
                if (!uRI.equals(u)) continue;
                found = true;
            }
            if (found) continue;
            onlyApprovedURIS = false;
        }
        if (onlyApprovedURIS) {
            this.folder.setSelection(this.approvedTab);
            ArrayList<Service> chainServices = new ArrayList<Service>();
            for (URI u : chainUris) {
                String ustring = u.toString();
                for (Service service : this.approvedServices) {
                    if (!service.getUri().equals(ustring)) continue;
                    chainServices.add(service);
                }
            }
            this.approvedViewer.setSelection((ISelection)new StructuredSelection(chainServices), true);
        } else {
            this.folder.setSelection(this.allTab);
            ArrayList<TextGridObject> chainTGOs = new ArrayList<TextGridObject>();
            for (URI u : chainUris) {
                TextGridObject tgo = null;
                try {
                    tgo = TextGridObject.getInstance((URI)u, (boolean)false);
                }
                catch (CrudServiceException crudServiceException) {
                    crudServiceException.printStackTrace();
                }
                chainTGOs.add(tgo);
            }
            this.allViewer.setSelection((ISelection)new StructuredSelection(chainTGOs), true);
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public boolean isPageComplete() {
        if (!this.approvedViewer.getSelection().isEmpty() || !this.allViewer.getSelection().isEmpty()) {
            if (!this.servicesLocked) {
                TabItem[] tiarr = this.folder.getSelection();
                this.newServices = new ArrayList();
                if (tiarr[0].equals(this.approvedTab)) {
                    IStructuredSelection wfss = (IStructuredSelection)this.approvedViewer.getSelection();
                    Iterator it = wfss.iterator();
                    while (it.hasNext()) {
                        TextGridObject serviceTGO = null;
                        try {
                            serviceTGO = TextGridObject.getInstance((URI)URI.create(((Service)it.next()).getUri()), (boolean)false);
                        }
                        catch (CrudServiceException e) {
                            e.printStackTrace();
                        }
                        this.newServices.add(serviceTGO);
                    }
                } else {
                    IStructuredSelection wfss = (IStructuredSelection)this.allViewer.getSelection();
                    Iterator it = wfss.iterator();
                    while (it.hasNext()) {
                        this.newServices.add((TextGridObject)it.next());
                    }
                }
            }
            return true;
        }
        return false;
    }

    public IWizardPage getPreviousPage() {
        return null;
    }

    public IWizardPage getNextPage() {
        if (this.newServices.size() > 0 && !this.servicesLocked) {
            this.chain.getChain().clear();
            this.chain.resetLinks();
        }
        for (TextGridObject service : this.newServices) {
            ChainEntry centry = new ChainEntry(service);
            if (centry != null && centry.getIncomingLinks() != null) {
                this.chain.addEntry(centry);
                continue;
            }
            MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 42);
            try {
                mb.setMessage(MessageFormat.format(Messages.ServiceSelectionPage_NoValidSDWarning, service.getTitle()));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            mb.open();
            return this;
        }
        this.setLockedServices(true);
        this.newServices = new ArrayList();
        ServiceOrderingPage so = ((WorkflowWizard)this.getWizard()).serviceOrdering;
        so.refreshViewer();
        return so;
    }

    public void selectionChanged(SelectionChangedEvent e) {
        boolean anyServiceIsSelected = false;
        if (e.getSource() == this.approvedViewer && !this.approvedViewer.getSelection().isEmpty()) {
            anyServiceIsSelected = true;
        } else if (e.getSource() == this.allViewer && !this.allViewer.getSelection().isEmpty()) {
            anyServiceIsSelected = true;
        }
        if (anyServiceIsSelected) {
            this.setPageComplete(this.isPageComplete());
            if (this.getWizard().getContainer().getCurrentPage() != null) {
                this.getWizard().getContainer().updateButtons();
            }
        }
    }

    class ApprovedServicesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ApprovedServicesLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof Service) {
                Service s = (Service)obj;
                return s.getName();
            }
            return "unknown class: " + obj.getClass();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

