/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.rcp_linkeditor.dialogs;

import info.textgrid.lab.core.browserfix.TextGridLabBrowser;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.linkeditor.rcp_linkeditor.Activator;
import info.textgrid.lab.linkeditor.rcp_linkeditor.dialogs.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LinksObjectContentDialog
extends TitleAreaDialog {
    private TextGridObject textGridObject;
    private Browser xmlTextField;

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayoutData((Object)new GridData(4, 4, true, true));
        dialogArea.setLayout((Layout)new GridLayout(1, false));
        this.setTitle(Messages.LinksObjectContentDialog_TheContentOfTheSelectedTILO);
        this.getShell().setText(Messages.LinksObjectContentDialog_ShowContent);
        this.xmlTextField = TextGridLabBrowser.createBrowser((Composite)dialogArea);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 600;
        this.xmlTextField.setLayoutData((Object)layoutData);
        this.xmlTextField.setText("<html><body><div style=\"height:100%;width:100%\"><textarea wrap=\"off\" readonly=\"true\" style=\"height:100%;width:100%;background:inherit\">" + this.renderContentAsHTML() + "</textarea></div></body></html>");
        this.setMessage(this.textGridObject.toString());
        return dialogArea;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            return super.createButton(parent, id, "Close", defaultButton);
        }
        return null;
    }

    private String renderContentAsHTML() {
        IStatus status = Status.OK_STATUS;
        try {
            IFile file = (IFile)this.textGridObject.getAdapter(IFile.class);
            InputStream in = file.getContents(true);
            return IOUtils.toString((InputStream)in, (String)"UTF-8");
        }
        catch (IOException e) {
            status = Activator.handleError(e, "Could not generate HTML representation of the content for {0}", this.getTextGridObject());
        }
        catch (CrudServiceException e) {
            status = Activator.handleError(e, "Could not generate HTML representation of the content for {0}", this.getTextGridObject());
        }
        catch (CoreException e) {
            status = Activator.handleError(e, "Could not generate HTML representation of the content for {0}", this.getTextGridObject());
        }
        catch (Exception e) {
            status = Activator.handleError(e, "Could not generate HTML representation of the content for {0}", this.getTextGridObject());
        }
        return MessageFormat.format("<html><head><title>Error</title></head><body><p>{0}</p><p>The details have been logged.</p></body></html>", status);
    }

    public LinksObjectContentDialog(Shell parentShell, TextGridObject object) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.textGridObject = object;
    }

    public static LinksObjectContentDialog show(TextGridObject textGridObject, Shell parentShell) {
        LinksObjectContentDialog dialog = new LinksObjectContentDialog(parentShell, textGridObject);
        dialog.setBlockOnOpen(false);
        dialog.open();
        return dialog;
    }

    public void setTextGridObject(TextGridObject textGridObject) {
        this.textGridObject = textGridObject;
    }

    public TextGridObject getTextGridObject() {
        return this.textGridObject;
    }
}

