/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.rcp_linkeditor.handlers;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.linkeditor.controller.LinkEditorController;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class DefaultOpenHandler
extends AbstractHandler
implements IHandler {
    private static final String LINKEDITOR_PERSPECTIVE = "info.textgrid.lab.linkeditor.rcp_linkeditor.perspective";
    private static final String PARAMETER_URI_ID = "info.textgrid.lab.linkeditor.rcp_linkeditor.defaultOpen.parameter1";
    private static final String PARAMETER_READONLY_ID = "info.textgrid.lab.linkeditor.rcp_linkeditor.defaultOpen.parameter2";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String parameterURI = null;
        TextGridObject object = null;
        ISelection selection = null;
        parameterURI = event.getParameter(PARAMETER_URI_ID);
        event.getParameter(PARAMETER_READONLY_ID);
        if (parameterURI != null) {
            try {
                object = TextGridObject.getInstance((URI)new URI(parameterURI), (boolean)false);
            }
            catch (CrudServiceException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "RCP_Linkeditor", "Could not retrieve TextGrid object.", (Throwable)e));
            }
            catch (URISyntaxException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "RCP_Linkeditor", "Could not retrieve TextGrid object.", (Throwable)e));
            }
        } else {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                object = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
            }
        }
        if (object != null) {
            try {
                if (TGContentType.of((String)"text/linkeditorlinkedfile").equals(object.getContentType(false))) {
                    PlatformUI.getWorkbench().showPerspective(LINKEDITOR_PERSPECTIVE, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    LinkEditorController.getInstance().openAnnotatedObject(object);
                } else if (object.getContentType(false).getId().contains("image")) {
                    PlatformUI.getWorkbench().showPerspective(LINKEDITOR_PERSPECTIVE, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    LinkEditorController.getInstance().addObjectToLinkEditor(object, true, true);
                } else if (TGContentType.of((String)"text/xml").equals(object.getContentType(false)) && LINKEDITOR_PERSPECTIVE.equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId())) {
                    LinkEditorController.getInstance().addObjectToLinkEditor(object, true, true);
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "RCP_Linkeditor");
            }
        }
        return null;
    }
}

