/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import info.textgrid.lab.core.efs.tgcrud.ExceptionPassingPipedInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.MessageFormat;
import java.util.concurrent.Semaphore;

public class ExceptionPassingPipedOutputStream
extends PipedOutputStream {
    private ICloseExceptionHandler closeExceptionHandler = null;
    private volatile boolean closed = false;
    private boolean blockingClose = false;
    private Semaphore mayQuitClose = new Semaphore(0);
    private Throwable exception = null;
    private PipedInputStream sink;

    public void setCloseExceptionHandler(ICloseExceptionHandler handler) {
        this.closeExceptionHandler = handler;
    }

    public ExceptionPassingPipedOutputStream() {
    }

    public ExceptionPassingPipedOutputStream(ExceptionPassingPipedInputStream snk) throws IOException {
        super(snk);
    }

    public void setBlockingClose(boolean blockingClose) {
        this.blockingClose = blockingClose;
    }

    public boolean isBlockingClose() {
        return this.blockingClose;
    }

    synchronized void setException(Throwable e) {
        this.exception = e;
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    protected synchronized void tryThrowException() throws IOException {
        if (this.exception == null) {
            return;
        }
        if (this.exception instanceof IOException) {
            IOException e = (IOException)this.exception;
            this.exception = null;
            throw e;
        }
        if (this.exception instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)this.exception;
            this.exception = null;
            throw e;
        }
        OtherSideException otherSideException = new OtherSideException(this.exception);
        this.exception = null;
        throw otherSideException;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.tryThrowException();
        super.flush();
        this.tryThrowException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.tryThrowException();
        super.write(b, off, len);
        this.tryThrowException();
    }

    @Override
    public void write(int b) throws IOException {
        this.tryThrowException();
        super.write(b);
        this.tryThrowException();
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.closed) {
            return;
        }
        if (this.blockingClose) {
            try {
                this.mayQuitClose.acquire();
            }
            catch (InterruptedException e) {
                IOException ioe = new IOException("Interrupted while waiting for close lock.");
                ioe.initCause(e);
                throw ioe;
            }
        }
        this.closed = true;
        if (this.closeExceptionHandler != null && this.exception != null && this.closeExceptionHandler.handleException(this.exception)) {
            this.exception = null;
        }
        this.tryThrowException();
    }

    @Override
    public synchronized void connect(PipedInputStream snk) throws IOException {
        super.connect(snk);
        this.sink = snk;
        if (this.sink instanceof ExceptionPassingPipedInputStream) {
            ((ExceptionPassingPipedInputStream)this.sink).setSource(this);
        }
    }

    synchronized void setSink(ExceptionPassingPipedInputStream sink) {
        this.sink = sink;
    }

    public void done() {
        this.mayQuitClose.release();
    }

    public static interface ICloseExceptionHandler {
        public boolean handleException(Throwable var1) throws IOException;
    }

    public static class OtherSideException
    extends IOException {
        private static final long serialVersionUID = 929216423625298296L;

        public OtherSideException(Throwable cause) {
            super(MessageFormat.format("A {0} occurred on the reading side of the pipe: {1}", cause.getClass().getSimpleName(), cause.getMessage()));
            this.initCause(cause);
        }
    }
}

