/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import com.ibm.icu.text.MessageFormat;
import info.textgrid.lab.core.efs.tgcrud.Activator;
import info.textgrid.lab.core.efs.tgcrud.MappingWrapper;
import info.textgrid.lab.core.swtutils.MultipleInputDialog;
import info.textgrid.lab.core.swtutils.SWTFactory;
import info.textgrid.lab.core.swtutils.TextValidator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class FileExtensionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer extensionTable;
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected SimpleExtensionContentProvider extensionsContentProvider = new SimpleExtensionContentProvider();
    protected static final String CONTENT_TYPE_LABEL = "TextGrid Content Type (Regular Expression)";
    protected static final String FILE_EXTENSION_LABEL = "File Extension";
    protected static final String FILE_EXTENSION_PREFERENCE_KEY = "info.textgrid.lab.core.efs.tgcrud.FileExtensionPreferencePage";
    protected static final String FILE_EXTENSION_PREFERENCE_PAGE = "info.textgrid.lab.core.efs.tgcrud.FileExtensionPreferencePage_context";
    protected static String[] variableTableColumnProperties = new String[]{"contentType", "extension"};
    protected String[] variableTableColumnHeaders = new String[]{"TextGrid Content Type", "File Extension"};
    protected ColumnLayoutData[] variableTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(70), new ColumnWeightData(30)};

    public FileExtensionsPreferencePage() {
        this.setDescription("Configures the mapping between TextGrid Content Types (as regular expression matching the objects' content type metadata field) and the internal file extensions.");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), FILE_EXTENSION_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setFont(font);
        this.createTable(composite);
        this.createButtons(composite);
        return composite;
    }

    private void createTable(Composite parent) {
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 400;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        this.extensionTable = new TableViewer(tableComposite, 68354);
        Table table = this.extensionTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(font);
        gridData = new GridData(1808);
        this.extensionTable.getControl().setLayoutData((Object)gridData);
        this.extensionTable.setContentProvider((IContentProvider)this.extensionsContentProvider);
        this.extensionTable.setColumnProperties(variableTableColumnProperties);
        this.extensionTable.addFilter((ViewerFilter)new VariableFilter());
        this.extensionTable.setComparator(new ViewerComparator(){

            public int compare(Viewer iViewer, Object e1, Object e2) {
                if (e1 == null) {
                    return -1;
                }
                if (e2 == null) {
                    return 1;
                }
                return ((MappingWrapper)e1).getContentType().compareToIgnoreCase(((MappingWrapper)e2).getContentType());
            }
        });
        this.extensionTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileExtensionsPreferencePage.this.handleTableSelectionChanged(event);
            }
        });
        this.extensionTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!FileExtensionsPreferencePage.this.extensionTable.getSelection().isEmpty()) {
                    FileExtensionsPreferencePage.this.handleEditButtonPressed();
                }
            }
        });
        this.extensionTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    FileExtensionsPreferencePage.this.handleRemoveButtonPressed();
                }
            }
        });
        int i = 0;
        while (i < this.variableTableColumnHeaders.length) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(this.variableTableColumnLayouts[i].resizable);
            tc.setText(this.variableTableColumnHeaders[i]);
            ++i;
        }
        if (!this.restoreColumnWidths()) {
            this.restoreDefaultColumnWidths();
        }
        this.extensionTable.setInput(Activator.getDefault().getTypeExtensionMappings());
        this.extensionTable.setLabelProvider((IBaseLabelProvider)new SimpleVariableLabelProvider());
    }

    private void createButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.numColumns = 1;
        GridData gdata = new GridData(2);
        buttonComposite.setLayout((Layout)glayout);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        this.envAddButton = SWTFactory.createPushButton((Composite)buttonComposite, (String)"Add", null);
        this.envAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileExtensionsPreferencePage.this.handleAddButtonPressed();
            }
        });
        this.envEditButton = SWTFactory.createPushButton((Composite)buttonComposite, (String)"Edit", null);
        this.envEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileExtensionsPreferencePage.this.handleEditButtonPressed();
            }
        });
        this.envEditButton.setEnabled(false);
        this.envRemoveButton = SWTFactory.createPushButton((Composite)buttonComposite, (String)"Remove", null);
        this.envRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileExtensionsPreferencePage.this.handleRemoveButtonPressed();
            }
        });
        this.envRemoveButton.setEnabled(false);
    }

    private void handleAddButtonPressed() {
        boolean done = false;
        String content_type = null;
        String extension = null;
        while (!done) {
            MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), "New Content Type - File Type Mapping");
            dialog.addTextField(CONTENT_TYPE_LABEL, content_type, (TextValidator)new NonemptyREValidator());
            dialog.addTextField(FILE_EXTENSION_LABEL, extension, false);
            if (dialog.open() != 0) {
                done = true;
                continue;
            }
            content_type = dialog.getStringValue(CONTENT_TYPE_LABEL).trim();
            extension = dialog.getStringValue(FILE_EXTENSION_LABEL);
            done = this.addExtension(content_type, extension);
        }
    }

    private boolean addExtension(String content_type, String extension) {
        if (content_type == null || content_type.length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Content Type", (String)"The value you provided is not a valid TextGrid content type.");
            return false;
        }
        List editedExtensions = this.extensionsContentProvider.getWorkingSetVariables();
        for (MappingWrapper currentExtension : editedExtensions) {
            String currentContentType;
            if (currentExtension.isRemoved() || !(currentContentType = currentExtension.getContentType()).equals(content_type)) continue;
            MessageDialog dialog = new MessageDialog(this.getShell(), "Confirmation Request", null, MessageFormat.format((String)"Replace the file extension for {0}?", (Object[])new String[]{content_type}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            int overWrite = dialog.open();
            if (overWrite == 0) {
                currentExtension.setExtension(extension);
                this.extensionTable.update((Object)currentExtension, null);
                return true;
            }
            return overWrite != 1;
        }
        MappingWrapper newVariable = new MappingWrapper(content_type, extension);
        this.extensionsContentProvider.addMapping(newVariable);
        this.extensionTable.refresh();
        return true;
    }

    private void handleEditButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.extensionTable.getSelection();
        MappingWrapper mappingWrapper = (MappingWrapper)selection.getFirstElement();
        if (mappingWrapper == null) {
            return;
        }
        String extension = mappingWrapper.getExtension();
        String content_type = mappingWrapper.getContentType();
        MultipleInputDialog dialog = new MultipleInputDialog(this.getShell(), MessageFormat.format((String)"Edit {0} Mapping", (Object[])new String[]{content_type}));
        dialog.addTextField(CONTENT_TYPE_LABEL, content_type, (TextValidator)new NonemptyREValidator());
        dialog.addTextField(FILE_EXTENSION_LABEL, extension, false);
        if (dialog.open() == 0) {
            extension = dialog.getStringValue(FILE_EXTENSION_LABEL);
            if (extension != null) {
                mappingWrapper.setExtension(extension);
            }
            this.extensionTable.update((Object)mappingWrapper, null);
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.extensionTable.getSelection();
        List mappingsToRemove = selection.toList();
        MappingWrapper[] variables = mappingsToRemove.toArray(new MappingWrapper[0]);
        int i = 0;
        while (i < variables.length) {
            variables[i].setRemoved(true);
            ++i;
        }
        this.extensionTable.refresh();
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        MappingWrapper extension = (MappingWrapper)selection.getFirstElement();
        if (extension == null) {
            this.envEditButton.setEnabled(false);
            this.envRemoveButton.setEnabled(false);
        } else {
            this.envEditButton.setEnabled(selection.size() == 1);
            this.envRemoveButton.setEnabled(selection.size() > 0);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.extensionsContentProvider.init();
        this.extensionTable.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        this.extensionsContentProvider.saveChanges();
        this.saveColumnWidths();
        return super.performOk();
    }

    public void saveColumnWidths() {
        StringBuffer widthPreference = new StringBuffer();
        int i = 0;
        while (i < this.extensionTable.getTable().getColumnCount()) {
            widthPreference.append(this.extensionTable.getTable().getColumn(i).getWidth());
            widthPreference.append(',');
            ++i;
        }
        if (widthPreference.length() > 0) {
            Activator.getDefault().getPreferenceStore().setValue(FILE_EXTENSION_PREFERENCE_KEY, widthPreference.toString());
        }
    }

    private boolean restoreColumnWidths() {
        int columnCount;
        String[] columnWidthStrings = Activator.getDefault().getPreferenceStore().getString(FILE_EXTENSION_PREFERENCE_KEY).split(",");
        if (columnWidthStrings.length != (columnCount = this.extensionTable.getTable().getColumnCount())) {
            return false;
        }
        int i = 0;
        while (i < columnCount) {
            try {
                int columnWidth = Integer.parseInt(columnWidthStrings[i]);
                this.extensionTable.getTable().getColumn(i).setWidth(columnWidth);
            }
            catch (NumberFormatException e) {
                Activator.getDefault().handleProblem(2, "Problem loading persisted column sizes for StringVariablePreferencesPage", e);
            }
            ++i;
        }
        return true;
    }

    private void restoreDefaultColumnWidths() {
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < this.variableTableColumnLayouts.length) {
            layout.addColumnData(this.variableTableColumnLayouts[i]);
            ++i;
        }
        this.extensionTable.getTable().setLayout((Layout)layout);
    }

    class NonemptyREValidator
    extends TextValidator {
        NonemptyREValidator() {
        }

        public boolean validate() {
            Pattern pattern = null;
            try {
                if (this.textWidget != null && !this.textWidget.getText().equals("")) {
                    pattern = Pattern.compile(this.textWidget.getText());
                }
            }
            catch (Exception exception) {}
            return pattern != null;
        }
    }

    private class SimpleExtensionContentProvider
    implements IStructuredContentProvider {
        private LinkedList<MappingWrapper> fWorkingSet = Activator.getDefault().getTypeExtensionMappings();

        private SimpleExtensionContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fWorkingSet.toArray();
        }

        public void addMapping(MappingWrapper mapping) {
            this.fWorkingSet.add(mapping);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            this.init();
        }

        public void saveChanges() {
            Activator.getDefault().setTypeExtensionMappings(this.fWorkingSet);
        }

        public void init() {
            this.fWorkingSet = Activator.getDefault().getTypeExtensionMappings();
        }

        public List getWorkingSetVariables() {
            return this.fWorkingSet;
        }
    }

    private class SimpleVariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private SimpleVariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof MappingWrapper) {
                MappingWrapper variable = (MappingWrapper)element;
                switch (columnIndex) {
                    case 0: {
                        StringBuffer name = new StringBuffer();
                        name.append(variable.getContentType());
                        return name.toString();
                    }
                    case 1: {
                        String value = variable.getExtension();
                        if (value == null) {
                            value = "";
                        }
                        return value;
                    }
                }
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class VariableFilter
    extends ViewerFilter {
        VariableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !((MappingWrapper)element).isRemoved();
        }
    }
}

