/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.efs.tgcrud.Activator;
import info.textgrid.lab.core.efs.tgcrud.CloseExceptionHandler;
import info.textgrid.lab.core.efs.tgcrud.ExceptionPassingPipedInputStream;
import info.textgrid.lab.core.efs.tgcrud.ExceptionPassingPipedOutputStream;
import info.textgrid.lab.core.efs.tgcrud.InputStreamDataSource;
import info.textgrid.lab.core.efs.tgcrud.LoggingInputStream;
import info.textgrid.lab.core.efs.tgcrud.MetadataRetrievalException;
import info.textgrid.lab.core.efs.tgcrud.TGDummyParent;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.LogUtil;
import info.textgrid.lab.core.tgcrud.client.CrudClientUtilities;
import info.textgrid.lab.log.logsession;
import info.textgrid.lab.ui.core.dialogs.TGCrudWarning;
import info.textgrid.namespaces.metadata.core._2010.MetadataContainerType;
import info.textgrid.namespaces.metadata.core._2010.ObjectFactory;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.AuthFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.IoFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.MetadataParseFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.ws.Holder;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class TGNewFileFileStore
extends FileStore
implements IFileStore {
    private URI uri;

    public TGNewFileFileStore(URI uri) {
        this.uri = uri;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return new String[0];
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        FileInfo fileInfo = new FileInfo(this.getName());
        fileInfo.setExists(true);
        fileInfo.setLastModified(1L);
        return fileInfo;
    }

    public IFileStore getChild(String name) {
        return null;
    }

    public String getName() {
        return new Path(this.uri.getPath()).lastSegment().toString();
    }

    public IFileStore getParent() {
        return new TGDummyParent(this);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        byte[] initialContent = this.getTextGridObject().getInitialContent();
        ByteArrayInputStream result = initialContent == null ? new ByteArrayInputStream(new byte[0]) : new ByteArrayInputStream(initialContent);
        return result;
    }

    public URI toURI() {
        return this.uri;
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        ExceptionPassingPipedOutputStream outputStream = new ExceptionPassingPipedOutputStream();
        outputStream.setBlockingClose(true);
        outputStream.setCloseExceptionHandler(new CloseExceptionHandler(this, "Save (create) failed"));
        final TextGridObject tgo = this.getTextGridObject();
        final TextGridProject project = tgo.getProjectInstance();
        project.assertPermission(2, "Access denied: You do not have the permission to create new objects in {0}.", new Object[]{project});
        try {
            final ExceptionPassingPipedInputStream inputStream = new ExceptionPassingPipedInputStream(outputStream);
            Thread serviceThread = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            try {
                                try {
                                    Holder metadataHolder = new Holder();
                                    metadataHolder.value = new ObjectFactory().createMetadataContainerType();
                                    ((MetadataContainerType)metadataHolder.value).setObject(tgo.getMetadata());
                                    DataHandler dataHandler = new DataHandler((DataSource)new InputStreamDataSource(new LoggingInputStream(inputStream, new LogUtil("info.textgrid.lab.core.efs.tgcrud")), "application/octet-stream", TGNewFileFileStore.this.getName()));
                                    String URI2 = tgo.getPreparedURI() == null ? null : tgo.getPreparedURI().toString();
                                    boolean isRevision = false;
                                    if (!tgo.getRevisionURI().equals("")) {
                                        isRevision = true;
                                        URI2 = tgo.getRevisionURI();
                                    }
                                    Activator.logServiceCall("Calling TGcrud#create({0}, {1}, {2}) ... (from TGNewFileOutputStream#close)", logsession.getInstance().getloginfo(), RBACSession.getInstance().getSID(false), ((MetadataContainerType)metadataHolder.value).getObject());
                                    TGCrudService crudServiceStub = CrudClientUtilities.getCrudServiceStub();
                                    crudServiceStub.create(RBACSession.getInstance().getSID(false), logsession.getInstance().getloginfo(), URI2, Boolean.valueOf(isRevision), project.getId(), metadataHolder, dataHandler);
                                    final ObjectType newMetadata = ((MetadataContainerType)metadataHolder.value).getObject();
                                    Activator.logServiceCall("... #create succeeded => {0}", newMetadata.toString());
                                    tgo.setRevisionURI("");
                                    UIJob uiJob = new UIJob("TGCrudWarning"){

                                        public IStatus runInUIThread(IProgressMonitor monitor) {
                                            try {
                                                TGCrudWarning dlg = TGCrudWarning.getInstance((List)newMetadata.getGeneric().getGenerated().getWarning(), (String)tgo.getTitle(), (String)tgo.toString());
                                                if (dlg != null) {
                                                    dlg.OpenDialog();
                                                }
                                            }
                                            catch (CoreException e) {
                                                StatusManager.getManager().handle(e, "info.textgrid.lab.core.efs.tgcrud");
                                            }
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    uiJob.setSystem(true);
                                    uiJob.schedule();
                                    TGNewFileFileStore.this.getTextGridObject().move(newMetadata);
                                    tgo.setMetadataDirty(false);
                                    tgo.setInitialContent(null);
                                    TextGridObject.notifyListeners((TextGridObject.ITextGridObjectListener.Event)TextGridObject.ITextGridObjectListener.Event.CREATED, (TextGridObject)tgo);
                                }
                                catch (CoreException e) {
                                    IOException ioe = new IOException(e.getLocalizedMessage(), e);
                                    throw ioe;
                                }
                                catch (MetadataParseFault e) {
                                    RemoteException ioe = new RemoteException(e.getLocalizedMessage(), e);
                                    throw ioe;
                                }
                                catch (IoFault e) {
                                    RemoteException ioe = new RemoteException(e.getLocalizedMessage(), e);
                                    throw ioe;
                                }
                                catch (AuthFault e) {
                                    RemoteException ioe = new RemoteException(e.getLocalizedMessage(), e);
                                    throw ioe;
                                }
                            }
                            catch (MetadataRetrievalException e) {
                                Throwable cause = e.getCause();
                                if (cause == null) {
                                    cause = e;
                                }
                                Activator.logServiceCall("TGcrud#update failed in TGNewFileOutputStream#close() with {0}", cause);
                                TextGridObject.notifyListeners((TextGridObject.ITextGridObjectListener.Event)TextGridObject.ITextGridObjectListener.Event.METADATA_INCOMPLETE, (TextGridObject)tgo);
                                String msg = NLS.bind((String)"Cannot save TextGridObject {0} because its metadata is invalid. Please check and fix it in the metadata view.", (Object)tgo);
                                throw new MetadataRetrievalException(msg, new MetadataRetrievalException(msg, e));
                            }
                        }
                        catch (Throwable e) {
                            Throwable cause = e.getCause();
                            if (cause == null) {
                                cause = e;
                            }
                            Activator.logServiceCall("TGcrud#create failed in TGNewFileOutputStream#close with {0}", cause);
                            inputStream.passOnException(e);
                            inputStream.done();
                        }
                    }
                    finally {
                        inputStream.done();
                    }
                }
            };
            serviceThread.setName(MessageFormat.format("Creating {0} in the TextGridRep", this.getName()));
            serviceThread.start();
        }
        catch (IOException e) {
            throw new CrudServiceException((Throwable)e, tgo.getURI());
        }
        return outputStream;
    }

    public TextGridObject getTextGridObject() throws CrudServiceException {
        return TextGridObject.getInstance((URI)this.uri, (boolean)false);
    }
}

