/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.utils;

import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.search.DeferredTreeContentProvider;
import info.textgrid.lab.ui.core.utils.Activator;
import info.textgrid.lab.ui.core.utils.Messages;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

public class CheckboxProjectNavigator
extends CheckboxTreeViewer {
    public CheckboxProjectNavigator(Composite parent) {
        this(parent, TextGridProjectRoot.LEVELS.EDITOR, 0);
    }

    public CheckboxProjectNavigator(Composite parent, TextGridProjectRoot.LEVELS level, int style) {
        super(parent, style);
        this.setContentProvider((IContentProvider)new CheckboxProjectNavigatorContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TGODefaultLabelProvider(true));
        this.setSorter(new ViewerSorter());
        this.setInput(TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)level));
    }

    public ViewerFilter setContentTypeFilter(String contentTypeID) {
        ProjectNavigatorFilter filter = new ProjectNavigatorFilter(contentTypeID);
        this.addFilter(filter);
        return filter;
    }

    public ViewerFilter setWorkFilter() {
        ProjectNavigatorWorkFilter filter = new ProjectNavigatorWorkFilter();
        this.addFilter(filter);
        return filter;
    }

    public ViewerFilter setXmlImageFilter() {
        ProjectNavigatorXmlImageFilter filter = new ProjectNavigatorXmlImageFilter();
        this.addFilter(filter);
        return filter;
    }

    class CheckboxProjectNavigatorContentProvider
    extends DeferredTreeContentProvider {
        CheckboxProjectNavigatorContentProvider() {
        }

        public boolean hasChildren(Object element) throws IllegalStateException {
            return false;
        }
    }

    class ProjectNavigatorFilter
    extends ViewerFilter {
        private String contentTypeID;

        ProjectNavigatorFilter(String contentTypeID) {
            this.contentTypeID = contentTypeID;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TGObjectReference) {
                TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (tgo != null) {
                    try {
                        return tgo.getContentTypeID().equals(this.contentTypeID);
                    }
                    catch (CoreException e) {
                        Activator.handleProblem(2, Messages.ProjectNavigator_WM_CouldNotRetrieveContentType, e);
                    }
                }
                return false;
            }
            return true;
        }
    }

    class ProjectNavigatorWorkFilter
    extends ViewerFilter {
        ProjectNavigatorWorkFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TGObjectReference) {
                TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (tgo != null) {
                    try {
                        return tgo.getContentTypeID().equals("text/tg.work+xml") || tgo.getContentTypeID().contains("tg.aggregation+xml");
                    }
                    catch (CoreException e) {
                        Activator.handleProblem(2, Messages.ProjectNavigator_WM_CouldNotRetrieveContentType, e);
                    }
                }
                return false;
            }
            return true;
        }
    }

    class ProjectNavigatorXmlImageFilter
    extends ViewerFilter {
        ProjectNavigatorXmlImageFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TGObjectReference) {
                TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (tgo != null) {
                    try {
                        String id = tgo.getContentTypeID();
                        return id.equals("text/xml") || id.contains("image/") || id.contains("tg.aggregation+xml");
                    }
                    catch (CoreException e) {
                        Activator.handleProblem(2, Messages.ProjectNavigator_WM_CouldNotRetrieveContentType, e);
                    }
                }
                return false;
            }
            return true;
        }
    }
}

