/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.utils;

import info.textgrid.lab.core.model.ITextGridProjectListener;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

public class ProjectCombo
extends ComboViewer
implements DeferredListContentProvider.IDoneListener,
ITextGridProjectListener {
    private final UpdatingDeferredListContentProvider contentProvider;
    private volatile boolean loadDone = false;
    protected TextGridProject selectedProject = null;
    private boolean needsValue = false;

    protected void updateSelection(ISelection selection) {
        TextGridProject project;
        if (!selection.isEmpty() && (project = (TextGridProject)AdapterUtils.getAdapter((Object)((IStructuredSelection)selection).getFirstElement(), TextGridProject.class)) != null) {
            this.selectedProject = project;
        }
        super.updateSelection(selection);
    }

    public boolean needsValue() {
        return this.needsValue;
    }

    public void setNeedsValue(boolean needsValue) {
        this.needsValue = needsValue;
    }

    public ProjectCombo(Composite parent) {
        this(parent, TextGridProjectRoot.LEVELS.EDITOR);
    }

    public ProjectCombo(Composite parent, TextGridProjectRoot.LEVELS level) {
        super(parent, 268435532);
        this.setLabelProvider((IBaseLabelProvider)new TGODefaultLabelProvider());
        this.contentProvider = new UpdatingDeferredListContentProvider();
        this.setContentProvider(this.contentProvider);
        this.setSorter(new ViewerSorter());
        this.contentProvider.addDoneListener(this);
        this.init(level);
    }

    public void loadDone(Viewer viewer) {
        this.setLoadDone(true);
        if (this.selectedProject == null && this.needsValue) {
            this.selectedProject = (TextGridProject)AdapterUtils.getAdapter((Object)this.getElementAt(0), TextGridProject.class);
        }
        if (this.selectedProject != null) {
            this.setProject(this.selectedProject);
        }
    }

    public void setProject(TextGridProject project) {
        this.selectedProject = project;
        if (this.isLoadDone()) {
            this.setSelection((ISelection)new StructuredSelection((Object)project), true);
        }
    }

    public TextGridProject getProject() {
        if (!this.getControl().isDisposed()) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            if (selection.isEmpty()) {
                return null;
            }
            return (TextGridProject)AdapterUtils.getAdapter((Object)selection.getFirstElement(), TextGridProject.class);
        }
        return this.selectedProject;
    }

    public void init(TextGridProjectRoot.LEVELS level) {
        this.setLoadDone(false);
        this.setInput(TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)level));
        TextGridProject.addListener((ITextGridProjectListener)this);
    }

    public void textGridProjectChanged(ITextGridProjectListener.Event event, TextGridProject project) {
        if (this.isLoadDone()) {
            switch (event) {
                case CREATED: {
                    this.add(project);
                    break;
                }
                case DELETED: {
                    this.remove(project);
                }
            }
        }
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        TextGridProject.removeListener((ITextGridProjectListener)this);
    }

    public void setLoadDone(boolean loadDone) {
        this.loadDone = loadDone;
    }

    public boolean isLoadDone() {
        return this.loadDone;
    }
}

