/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.utils;

import info.textgrid.lab.core.model.TGObjectReference;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class TextGridUriHtmlTransfer
extends ByteArrayTransfer {
    private static final String TEXT_HTML = "text/html";
    private static final int TEXT_HTML_ID = TextGridUriHtmlTransfer.registerType((String)"text/html");
    private static final String TEXT_HTML2 = "TEXT/HTML";
    private static final int TEXT_HTML2_ID = TextGridUriHtmlTransfer.registerType((String)"TEXT/HTML");
    private static final TextGridUriHtmlTransfer INSTANCE = new TextGridUriHtmlTransfer();

    protected TextGridUriHtmlTransfer() {
    }

    public static TextGridUriHtmlTransfer getTransfer() {
        return INSTANCE;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkTGO(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        TGObjectReference tgor = (TGObjectReference)object;
        String title = "";
        String type = "";
        try {
            title = tgor.getTgo().getTitle();
            type = tgor.getTgo().getContentTypeID();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String uri = String.valueOf(tgor.getRefUri()) + "." + tgor.getRevisionNumber();
        String string = "<li class='tgo' uri='" + uri + "' type='" + type + "'> " + title + " (" + uri + ") </li>";
        byte[] buff = string.getBytes();
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0 || os.indexOf("mac") > 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream writeOut = new DataOutputStream(out);
            int i = 0;
            while (i < buff.length) {
                try {
                    writeOut.write(buff[i]);
                    writeOut.write(new byte[1]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            buff = out.toByteArray();
        }
        super.javaToNative((Object)buff, transferData);
    }

    private boolean checkTGO(Object object) {
        return object != null && object instanceof TGObjectReference;
    }

    protected int[] getTypeIds() {
        return new int[]{TEXT_HTML_ID, TEXT_HTML2_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TEXT_HTML, TEXT_HTML2};
    }
}

