/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.dialogs;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.ui.core.dialogs.Messages;
import info.textgrid.namespaces.metadata.core._2010.GeneratedType;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class TGCrudWarning {
    private static TGCrudWarning instance = null;
    private static Boolean ToggleState = false;
    private MessageDialogWithToggle msg;
    private String DlgWarningMessage;
    private static final String TITLE = "TextGrid-CRUD Warning: ";
    private static final String TOGGLEMESSAGE = Messages.TGCrudWarning_UM_DoNotShowAgain;
    private static final String PLUGIN_ID = "info.textgrid.lab.core.efs.tgcrud";
    public static final String PREF_CRUDWARNING = "crudwarning";
    public static final String WARNINGINTRO = Messages.TGCrudWarning_WarningIntro;

    public static TGCrudWarning getInstance(List<GeneratedType.Warning> warningMessages, String tgObjectTitle, String tgString) {
        if (warningMessages.size() > 0) {
            ToggleState = ConfPlugin.getDefault().getPreferenceStore().getBoolean(PREF_CRUDWARNING);
            if (instance == null) {
                instance = new TGCrudWarning(warningMessages, tgObjectTitle, tgString);
            } else {
                instance.NewMessageDialogWithToggle(warningMessages, tgObjectTitle, tgString);
            }
            return instance;
        }
        return null;
    }

    private void NewMessageDialogWithToggle(List<GeneratedType.Warning> warningMessages, String tgObjectTitle, String tgString) {
        this.DlgWarningMessage = Joiner.on((String)"\n").join(Iterables.transform(warningMessages, (Function)new Function<GeneratedType.Warning, String>(){

            public String apply(GeneratedType.Warning warning) {
                return warning.getValue();
            }
        }));
        this.msg = new MessageDialogWithToggle(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TITLE + tgObjectTitle, null, String.valueOf(WARNINGINTRO) + "\n\nWarning: " + this.DlgWarningMessage, 4, new String[]{"Ok"}, 1, TOGGLEMESSAGE, ToggleState == false);
        if (!this.DlgWarningMessage.equals("*INIT")) {
            StatusManager.getManager().handle((IStatus)new Status(2, PLUGIN_ID, "TextGrid-Object: " + tgString + "; Message: " + this.DlgWarningMessage));
        }
    }

    private TGCrudWarning(List<GeneratedType.Warning> WarningMessages, String tgObjectTitle, String tgString) {
        this.NewMessageDialogWithToggle(WarningMessages, tgObjectTitle, tgString);
        ToggleState = false;
    }

    public void OpenDialog() {
        if (!this.msg.getToggleState()) {
            ConfPlugin.getDefault().getPreferenceStore().setValue(PREF_CRUDWARNING, !this.msg.getToggleState());
            if (this.msg.open() != -1) {
                ToggleState = this.msg.getToggleState();
            }
        }
    }
}

