/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectFile;
import info.textgrid.lab.ui.core.handlers.Messages;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import java.rmi.RemoteException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteProjectFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TextGridProject tgp;
        Object obj;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof TextGridProject && (tgp = (TextGridProject)((IAdaptable)obj).getAdapter(TextGridProject.class)) != null) {
            if (!MessageDialog.openQuestion((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)Messages.DeleteProjectFileHandler_DeleteProjectFile, (String)Messages.DeleteProjectFileHandler_IM_WantToDelete)) {
                return null;
            }
            Job delJob = new Job(Messages.DeleteProjectFileHandler_DeletingFile){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask(Messages.DeleteProjectFileHandler_DeletingFile, 100);
                        TextGridProjectFile pf = new TextGridProjectFile(TextGridProject.getProjectInstance((String)tgp.getId()));
                        TextGridObject projectFile = pf.getProjectFileObject(false, monitor);
                        monitor.worked(20);
                        tgp.unsetProjectFile();
                        monitor.worked(20);
                        projectFile.delete(monitor);
                        System.err.println(Messages.DeleteProjectFileHandler_FileDeleted);
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (CrudServiceException e) {
                        Activator.handleError((Throwable)e);
                    }
                    catch (OfflineException e) {
                        Activator.handleError((Throwable)e);
                    }
                    catch (RemoteException e) {
                        Activator.handleError((Throwable)e);
                    }
                    catch (AuthenticationFault e) {
                        Activator.handleError((Throwable)e);
                    }
                    catch (CoreException e) {
                        Activator.handleError((Throwable)e);
                    }
                    catch (ProjectDoesNotExistException e) {
                        Activator.handleError((Throwable)e);
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            delJob.setUser(true);
            delJob.schedule();
        }
        return null;
    }
}

