/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.search.FullTextEntry;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.handlers.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.statushandlers.StatusManager;

@Deprecated
public class OpenHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSel = (IStructuredSelection)selection;
            for (Object o : structuredSel.toList()) {
                OpenHandler.openObject(o, HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage(), event);
            }
        } else {
            Activator.handleProblem(4, NLS.bind((String)Messages.OpenHandler_CannotOpenSelection, (Object)selection), null);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IEditorPart openObject(Object o, IWorkbenchPage workbenchPage, ExecutionEvent event) {
        TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)o, TextGridObject.class);
        IFile file = (IFile)AdapterUtils.getAdapter((Object)o, IFile.class);
        if (file == null && textGridObject != null) {
            file = (IFile)AdapterUtils.getAdapter((Object)textGridObject, IFile.class);
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        IContentType eclipseContentType = null;
        if (textGridObject != null) {
            try {
                String format = textGridObject.getContentTypeID();
                if (format.contains("image") || format.equals("text/linkeditorlinkedfile")) {
                    try {
                        handlerService.executeCommand("info.textgrid.lab.linkeditor.rcp_linkeditor.defaultOpen", null);
                        return null;
                    }
                    catch (CommandException e) {
                        Activator.handleError(e, "Could not open the text image link editor.", new Object[0]);
                    }
                    return null;
                }
                if (format.equals("text/ttle")) {
                    try {
                        handlerService.executeCommand("info.textgrid.lab.ttle.defaultOpen", null);
                        return null;
                    }
                    catch (CommandException e) {
                        Activator.handleError(e, "Could not open the text text link editor.", new Object[0]);
                    }
                    return null;
                }
                if (format.contains("projectfile")) {
                    MessageDialog.openInformation(null, null, (String)"The object you tried to open is a project file, a TextGrid internal helper object that cannot be edited directly.\nPlease use the Metadata Template-Editor to edit it!");
                    return null;
                }
                if (format.equals("text/tg.work+xml")) {
                    try {
                        handlerService.executeCommand("info.textgrid.lab.ui.core.commands.OpenMDE", null);
                        return null;
                    }
                    catch (CommandException e) {
                        Status status = new Status(4, "info.textgrid.lab.ui.core", "Could not open Metadata Editor", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                    return null;
                }
                if (format.equals("application/x-digilib-json")) {
                    try {
                        handlerService.executeCommand("de.mpg.mpiwg.itgroup.textgrid.digilib.showImage", null);
                        return null;
                    }
                    catch (CommandException e) {
                        Status status = new Status(4, "info.textgrid.lab.ui.core", "Could not open Digilib viewer", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                    return null;
                }
            }
            catch (CoreException e1) {
                Activator.handleError(e1, "Could not extract {0}'s content type: {1}", textGridObject, e1.getMessage());
            }
            try {
                IEditorDescriptor editorDescriptor = null;
                IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
                TGContentType contentType = textGridObject.getContentType(false);
                if (contentType != null) {
                    eclipseContentType = contentType.getEclipseContentType();
                }
                if ((editorDescriptor = editorRegistry.getDefaultEditor(file.getName(), eclipseContentType)) == null) {
                    Activator.handleError(null, "Could not find an editor that can handle a {0}, so I cannot open {1}.", contentType, textGridObject);
                    return null;
                }
                if (editorDescriptor.getId().equals("info.textgrid.lab.xmleditor.mpeditor.MPEditorPart")) {
                    if ("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective".equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId())) {
                        try {
                            handlerService.executeCommand("info.textgrid.lab.linkeditor.rcp_linkeditor.defaultOpen", null);
                            return null;
                        }
                        catch (CommandException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.ui.core", "Could not open text image link editor.", (Throwable)e));
                        }
                        return null;
                    }
                    if ("info.textgrid.lab.ttle.perspective".equals(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId())) {
                        try {
                            handlerService.executeCommand("info.textgrid.lab.ttle.defaultOpen", null);
                            return null;
                        }
                        catch (CommandException e) {
                            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.ui.core", "Could not open text text link editor.", (Throwable)e));
                        }
                        return null;
                    }
                    try {
                        PlatformUI.getWorkbench().showPerspective("info.textgrid.lab.welcome.XMLEditorPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    }
                    catch (WorkbenchException e) {
                        Status status = new Status(4, "info.textgrid.lab.ui.core", "Could not open XML Editor Perspective!", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                } else if (editorDescriptor.getId().equals("info.textgrid.lab.core.aggregations.ui.editor")) {
                    try {
                        PlatformUI.getWorkbench().showPerspective("info.textgrid.lab.core.aggregations.ui.AggregationCompositionPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    }
                    catch (WorkbenchException e) {
                        Status status = new Status(4, "info.textgrid.lab.ui.core", "Could not open Aggregation Composer Perspective!", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                    IEditorInput input = (IEditorInput)AdapterUtils.getAdapter((Object)new TGObjectReference(textGridObject.getURI()), IEditorInput.class);
                    return workbenchPage.openEditor(input, editorDescriptor.getId());
                }
                FileEditorInput input = new FileEditorInput(file);
                IEditorPart editorPart = workbenchPage.openEditor((IEditorInput)input, editorDescriptor.getId());
                if (!(o instanceof FullTextEntry)) return editorPart;
                OpenHandler.callSelectByIDCommand((FullTextEntry)o);
                return editorPart;
            }
            catch (CoreException e) {
                Activator.handleError(e, "Could not open {0}.", textGridObject);
                return null;
            }
        }
        Activator.handleError(null, "Cannot open {0}. The open handler can currently only handle things that can be made a TextGridObject, but it has been called on the {1} {0}, which cannot.", o, o == null ? null : o.getClass().getSimpleName());
        return null;
    }

    private static void callSelectByIDCommand(FullTextEntry entry) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        Command command = commandService.getCommand("info.textgrid.lab.xmleditor.mpeditor.selectByID");
        try {
            IParameter parameterID = command.getParameter("info.textgrid.lab.xmleditor.mpeditor.selectByID.ID");
            Parameterization parameter1 = new Parameterization(parameterID, entry.getXpath());
            IParameter parameterSearchTerm = command.getParameter("info.textgrid.lab.xmleditor.mpeditor.selectByID.SearchTerm");
            Parameterization parameter2 = new Parameterization(parameterSearchTerm, entry.getMatch());
            ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parameter1, parameter2});
            handlerService.executeCommand(parmCommand, null);
        }
        catch (NotDefinedException e) {
            Activator.handleError(e, "Could not select {0} in XML editor.", entry);
        }
        catch (ExecutionException e) {
            Activator.handleError(e, "Could not select {0} in XML editor.", entry);
        }
        catch (NotEnabledException e) {
            Activator.handleError(e, "Could not select {0} in XML editor.", entry);
        }
        catch (NotHandledException e) {
            Activator.handleError(e, "Could not select {0} in XML editor.", entry);
        }
    }
}

