/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.tgpublish.client.gui.controller;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditor;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditorInput;
import info.textgrid.lab.core.metadataeditor.MetaDataView;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.util.ModelUtil;
import info.textgrid.lab.tgpublish.client.gui.Activator;
import info.textgrid.lab.tgpublish.client.gui.model.EditionObjectDataModel;
import info.textgrid.lab.tgpublish.client.gui.views.TGPublishView;
import info.textgrid.middleware.tgpublish.api.jaxb.Module;
import info.textgrid.middleware.tgpublish.api.jaxb.ProcessStatusType;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishError;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishObject;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishResponse;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishWarning;
import info.textgrid.middleware.tgpublish.api.jaxb.StatusType;
import info.textgrid.middleware.tgpublish.api.jaxb.WorldReadableMimetypes;
import info.textgrid.middleware.tgpublish.client.PublishClient;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXB;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class TGPublishController {
    private static final String SUCCESSFULL_PUBLISHED = " has been successful published!";
    private PublishResponse publishResponse = null;
    private PublishClient publishClient = null;
    private EditionObjectDataModel data = null;
    private List<EditionObjectDataModel> allData = new ArrayList<EditionObjectDataModel>();
    private TextGridObject tgObj = null;
    private String uri = "";
    private String sid = "";
    private String faildMessage = "";
    public boolean isReadyForPublishing = false;
    public boolean isCanceld = false;
    public boolean isWorldReadable = false;
    public boolean ignoreWarnings = false;
    public boolean publishStatusFailed = false;
    public boolean showLogs = false;
    public ProcessStatusType statusInfo = null;
    private int okCounts = 0;
    private int errorCounts = 0;
    private int warningCounts = 0;
    private Job job = null;
    private boolean simulateRun;
    private static TGPublishController instance = new TGPublishController();

    public Job getJob() {
        return this.job;
    }

    private TGPublishController() {
    }

    public static TGPublishController getInstance() {
        return instance;
    }

    public TextGridObject getTGObj() {
        return this.tgObj;
    }

    public void setTGObj(TextGridObject uri) {
        this.tgObj = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public String getFaildMessage() {
        return this.faildMessage;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public int getOKCounts() {
        return this.okCounts;
    }

    public int getErrorCounts() {
        return this.errorCounts;
    }

    public int getWarningCounts() {
        return this.warningCounts;
    }

    public static String getSuccessfullPublished() {
        return SUCCESSFULL_PUBLISHED;
    }

    public PublishResponse getPublishResponse() {
        return this.publishResponse;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean getWorldReadable() {
        return this.isWorldReadable;
    }

    public void setWorldReadable(boolean isWorldReadable) {
        this.isWorldReadable = isWorldReadable;
    }

    public void setPublishStatusFailed(boolean status) {
        this.publishStatusFailed = status;
    }

    public void callTGPublishClient(final String client) {
        this.statusInfo = null;
        this.isCanceld = false;
        this.simulateRun = true;
        this.job = new Job("call tgpublish"){
            String message;
            Object bres;
            {
                super($anonymous0);
                this.message = "";
                this.bres = null;
            }

            protected IStatus run(IProgressMonitor monitor) {
                TGPublishController.this.Log("bres: " + this.bres);
                if (monitor.isCanceled()) {
                    TGPublishController.this.isCanceld = true;
                    return Status.CANCEL_STATUS;
                }
                if (client.equals("WorldReadable")) {
                    TGPublishController.this.Log("---->WorldReadable: ");
                    this.message = "An error occured while calling TGPublish-Client(WR)!";
                    TGPublishController.this.simulateRun = false;
                    this.bres = TGPublishController.this.publishClient.publishWorldReadable(TGPublishController.this.uri).getEntity();
                } else if (client.equals("WordReadableSimulate")) {
                    TGPublishController.this.Log("---->WordReadableSimulate: ");
                    this.message = "An error occured while calling TGPublish-Client(WR-Simulate)!";
                    this.bres = TGPublishController.this.publishClient.publishWorldReadableSimulate(TGPublishController.this.uri).getEntity();
                } else if (client.equals("Simulate")) {
                    TGPublishController.this.Log("---->Simulate: ");
                    this.message = "An error occured while calling TGPublish-Client(Simulate)!";
                    this.bres = TGPublishController.this.publishClient.publishSimulate(TGPublishController.this.uri).getEntity();
                } else if (client.equals("IgnoreWarnings")) {
                    TGPublishController.this.Log("---->IgnoreWarnings: ");
                    this.message = "An error occured while calling the TGPublish-Client(IW)!";
                    TGPublishController.this.simulateRun = false;
                    this.bres = TGPublishController.this.publishClient.publishIgnoreWarnings(TGPublishController.this.uri).getEntity();
                } else if (client.equals("Publish")) {
                    TGPublishController.this.Log("---->Publish: ");
                    this.message = "An error occured while calling the TGPublish-Client!";
                    TGPublishController.this.simulateRun = false;
                    this.bres = TGPublishController.this.publishClient.publish(TGPublishController.this.uri).getEntity();
                }
                ProcessStatusType status = null;
                int elapsedTime = 3000;
                int elapsedTime4NOT_QUEUED = 10000;
                do {
                    if (monitor.isCanceled()) {
                        TGPublishController.this.isCanceld = true;
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        Thread.sleep(elapsedTime);
                        elapsedTime = 0;
                        TGPublishController.this.publishResponse = TGPublishController.this.publishClient.getStatus(TGPublishController.this.uri);
                        status = TGPublishController.this.getPublishResponse().getPublishStatus().processStatus;
                        TGPublishController.this.Log("---->Status: " + status.toString());
                        TGPublishController.this.statusInfo = status;
                        int progressInfo = ((TGPublishController)TGPublishController.this).publishResponse.getPublishStatus().progress;
                        if (progressInfo != 0) {
                            TGPublishController.this.Log("progressInfo: " + progressInfo);
                            monitor.beginTask("TG-Publish is proofing...", 100);
                            monitor.worked(progressInfo);
                        }
                        if (status.toString().equals("NOT_QUEUED")) {
                            Thread.sleep(elapsedTime4NOT_QUEUED);
                            status = TGPublishController.this.getPublishResponse().getPublishStatus().processStatus;
                            TGPublishController.this.Log("---->Status: " + status.toString());
                            TGPublishController.this.statusInfo = status;
                        }
                        if (!status.toString().equals("RUNNING") && !status.toString().equals("NOT_QUEUED")) break;
                        TGPublishController.this.proofPublishStatus(status.toString());
                    }
                    catch (InterruptedException e) {
                        Activator.handleError(e, this.message, new Object[0]);
                    }
                    catch (Exception e) {
                        Activator.handleError(e, this.message, new Object[0]);
                    }
                } while (status.toString().equals("RUNNING"));
                monitor.done();
                TGPublishController.this.fillDataModel();
                return Status.OK_STATUS;
            }
        };
        this.job.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                UIJob uiJob = new UIJob("...tgpublish"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (monitor.isCanceled()) {
                            (this).TGPublishController.this.isCanceld = true;
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            ((TGPublishView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.tgpublish.client.gui.tgpview", null, 1)).updateMessageCounts();
                            TGPublishController.this.proofIsReadyForPublishing();
                        }
                        catch (PartInitException e) {
                            Activator.handleError(e, "Couldn't open the TGPublish View!", new Object[0]);
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.addJobChangeListener(new IJobChangeListener(){

                    public void sleeping(IJobChangeEvent event) {
                    }

                    public void scheduled(IJobChangeEvent event) {
                    }

                    public void running(IJobChangeEvent event) {
                    }

                    public void done(IJobChangeEvent event) {
                        try {
                            ((TGPublishView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.tgpublish.client.gui.tgpview", null, 1)).refreshViewer();
                            ((TGPublishView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.tgpublish.client.gui.tgpview", null, 1)).proofIsReadyForPublishing();
                            if (!TGPublishController.this.simulateRun && !((TGPublishController)(this).TGPublishController.this).publishResponse.dryRun.booleanValue()) {
                                ((TGPublishView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.tgpublish.client.gui.tgpview", null, 1)).forceTGPublishButtons();
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }

                    public void awake(IJobChangeEvent event) {
                    }

                    public void aboutToRun(IJobChangeEvent event) {
                    }
                });
                uiJob.setUser(true);
                uiJob.setName("...processing tgpublish");
                uiJob.schedule();
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
        this.job.setName("get result(s) from tgpublish...");
        this.job.schedule();
    }

    private void proofPublishStatus(String status) {
        if (status.equals("FAILED")) {
            this.publishStatusFailed = true;
            List statusListOfModules = this.publishClient.getStatus(this.uri).getPublishStatus().getModules();
            for (Module obj : statusListOfModules) {
                List modules = obj.getMessages();
                for (String message : modules) {
                    this.faildMessage = String.valueOf(this.faildMessage) + message;
                    this.faildMessage = String.valueOf(this.faildMessage) + "\n";
                }
            }
        }
    }

    public void testIfWorldReadableObject() {
        this.setWorldReadable(false);
        String contentTypeId = "";
        try {
            contentTypeId = this.tgObj.getContentTypeID();
        }
        catch (CoreException e) {
            Activator.handleError(e, "An error occured while getting the ContentType!", new Object[0]);
        }
        WorldReadableMimetypes wRMimeTypes = this.publishClient.getWorldReadables();
        ArrayList contTypeList = (ArrayList)wRMimeTypes.getWorldReadableList();
        for (String wRcontType : contTypeList) {
            if (!contentTypeId.matches(wRcontType)) continue;
            this.setWorldReadable(true);
        }
    }

    public void resetDataModel() {
        try {
            this.allData.clear();
        }
        catch (UnsupportedOperationException e) {
            Activator.handleError(e, "Couldn't clear the DataModel.", new Object[0]);
        }
    }

    public void fillDataModelPublished(String message) {
        this.resetDataModel();
        this.printResponse();
        String title = "";
        for (PublishObject obj : this.publishResponse.getPublishObjects()) {
            String uri = obj.uri;
            if (obj.status.equals((Object)StatusType.OK)) {
                try {
                    TextGridObject tgo = TextGridObject.getInstance((URI)new URI(uri), (boolean)false);
                    title = tgo.getTitle();
                }
                catch (CrudServiceException e) {
                    Activator.handleError(e, "An error occured while calling the CRUD-Service!", new Object[0]);
                }
                catch (CoreException e) {
                    Activator.handleError(e, "An error occured (CoreException)!", new Object[0]);
                }
                catch (URISyntaxException e) {
                    Activator.handleError(e, "An error occured (URI Syntax)!", new Object[0]);
                }
                catch (NullPointerException e) {
                    Activator.handleError(e, "An error occured (NullPointerException)!", new Object[0]);
                }
                this.data = new EditionObjectDataModel(title, message, "", "", uri);
                this.allData.add(this.data);
                this.reloadMetadata();
                continue;
            }
            if (!obj.status.equals((Object)StatusType.ERROR)) continue;
            this.Log("...it seems, something is wrong with tgpublish!");
        }
        UIJob uiJob2 = new UIJob("update Decorator Manager"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    TGPublishController.this.isCanceld = true;
                    return Status.CANCEL_STATUS;
                }
                PlatformUI.getWorkbench().getDecoratorManager().update("info.textgrid.lab.debug.decorators.TGOPublicDecorator");
                return Status.OK_STATUS;
            }
        };
        uiJob2.setName("update Decorator manager...");
        uiJob2.schedule();
    }

    private void reloadMetadata() {
        new Job("Reloading metadata..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    TGPublishController.this.tgObj.reloadMetadata(true);
                }
                catch (CoreException e) {
                    Activator.handleWarning(e, "Couldn't reload the Metadata ot the textgrid object");
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillDataModel() {
        String title = "";
        String uri = "";
        String message = "";
        String type = "";
        this.okCounts = 0;
        this.errorCounts = 0;
        this.warningCounts = 0;
        this.resetDataModel();
        this.printResponse();
        for (PublishObject obj : this.publishResponse.getPublishObjects()) {
            boolean merk;
            block28: {
                merk = false;
                title = "";
                message = "";
                type = "";
                this.errorCounts += obj.getErrors().size();
                this.warningCounts += obj.getWarnings().size();
                try {
                    uri = obj.uri;
                }
                catch (Exception e1) {
                    this.ErrorLog("uri" + uri);
                    Activator.handleError(e1, "An error occured while filling the DataModel!", new Object[0]);
                }
                try {
                    try {
                        title = TextGridObject.getInstance((URI)new URI(uri), (boolean)false).getTitle();
                    }
                    catch (CrudServiceException e) {
                        Activator.handleError(e, "An error occured while calling the CRUD-Service in <fillDataModel>!", new Object[0]);
                        if (title == null) {
                            title = "";
                        }
                        break block28;
                    }
                    catch (CoreException e) {
                        Activator.handleError(e, "An error occured (CoreException) in <fillDataModel>!", new Object[0]);
                        if (title == null) {
                            title = "";
                        }
                        break block28;
                    }
                    catch (URISyntaxException e) {
                        Activator.handleError(e, "An error occured (URI Syntax) in <fillDataModel>!", new Object[0]);
                        if (title == null) {
                            title = "";
                        }
                        break block28;
                    }
                    catch (NullPointerException e) {
                        Activator.handleError(e, "An error occured (NullPointerException) in <fillDataModel>!", new Object[0]);
                        if (title == null) {
                            title = "";
                        }
                        break block28;
                    }
                    catch (ModelUtil.InUIThreadException e) {
                        Activator.handleError(e, "An error occured (UIThread-Exception) in <fillDataModel>!", new Object[0]);
                        if (title == null) {
                            title = "";
                        }
                        break block28;
                    }
                    catch (Exception e) {
                        Activator.handleError(e, "An error occured in <fillDataModel>!", new Object[0]);
                        if (title == null) {
                            title = "";
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    if (title == null) {
                        title = "";
                    }
                    throw throwable;
                }
                if (title == null) {
                    title = "";
                }
            }
            if (title.equals("")) {
                title = "... (" + uri + " )";
            }
            for (PublishError error : obj.getErrors()) {
                message = error.getMessage();
                type = error.getType().toString();
                this.data = new EditionObjectDataModel(title, message, type, "red", uri);
                this.allData.add(this.data);
                merk = true;
            }
            for (PublishWarning warnings : obj.getWarnings()) {
                message = warnings.getMessage();
                type = warnings.getType().toString();
                this.data = new EditionObjectDataModel(title, message, type, "yellow", uri);
                this.allData.add(this.data);
                merk = true;
            }
            if (merk) continue;
            if (obj.status.toString().equals("ALREADY_PUBLISHED")) {
                this.data = new EditionObjectDataModel(title, "Object is already published.", "---", "info", uri);
            } else if (obj.status.toString().equals("OK")) {
                ++this.okCounts;
                this.data = new EditionObjectDataModel(title, "ok", "---", "green", uri);
            } else {
                this.data = obj.status.toString().equals("NOT_YET_PUBLISHED") ? new EditionObjectDataModel(title, "Not yet published, please try again.", "---", "info", uri) : new EditionObjectDataModel(title, "ok", "---", "green", uri);
            }
            this.allData.add(this.data);
        }
    }

    private void printResponse() {
        if (this.showLogs) {
            try {
                JAXB.marshal((Object)this.publishResponse, (OutputStream)System.out);
            }
            catch (NullPointerException e) {
                e.getStackTrace();
            }
            catch (Exception e) {
                Activator.handleError(e, "An error occured while marshalling object!", new Object[0]);
            }
            this.Log("uri: " + this.uri);
            this.Log("sid: " + this.sid);
        }
    }

    public void proofIsReadyForPublishing() {
        this.Log("proofIsReadyForPublishing:--->" + this.statusInfo.toString());
        if (!(this.isCanceld || this.statusInfo.toString().equals("FAILED") || this.statusInfo.toString().equals("NOT_QUEUED"))) {
            if (this.errorCounts == 0 && this.warningCounts == 0 && !this.statusInfo.toString().equals("FAILED")) {
                this.isReadyForPublishing = true;
            } else if (this.errorCounts == 0 && !this.publishStatusFailed) {
                this.setIgnoreWarnings(true);
                this.isReadyForPublishing = true;
            } else {
                this.publishStatusFailed = false;
                if (false) {
                    this.isReadyForPublishing = false;
                }
            }
        } else {
            this.isReadyForPublishing = false;
        }
    }

    public List<EditionObjectDataModel> getDataModel() {
        return this.allData;
    }

    public Object callRightAction(String[] strArr) {
        String message = strArr[0];
        String xPath = strArr[1];
        switch (ActionError.valueOf(message)) {
            case NOT_SPECIFIED: {
                return "...error not specified";
            }
            case AUTH: {
                return "...Object not existing or authorized.";
            }
            case WRONG_CONTENT_TYPE: {
                return "...Object is no Edition or Collection... setting worldreadable.";
            }
            case NO_PUBLISH_RIGHT: {
                try {
                    return this.call_COMPOSER_VIEW(message);
                }
                catch (PartInitException e) {
                    Activator.handleError(e, "An error occured while calling the Composer View!", new Object[0]);
                    return "...no right to publish object.";
                }
            }
            case METADATA_WARNINGS_EXIST: {
                return this.call_METADATA_VIEW(xPath, message);
            }
            case PID_GENERATION_FAILED: {
                return "...no PID could be generated.";
            }
            case MISSING_METADATA: {
                return this.call_METADATA_VIEW(xPath, message);
            }
            case ALREADY_PUBLISHED: {
                return "...the object is already published";
            }
            case SERVER_ERROR: {
                return "...Server Error occured.";
            }
        }
        return "???";
    }

    private Object call_METADATA_VIEW(String xpath, String messageType) {
        xpath = xpath.substring(6, xpath.length()).trim();
        this.Log("MDE  : " + xpath);
        try {
            MetaDataView metadataView = (MetaDataView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.core.metadataeditor.view");
            metadataView.triggerCheckField(xpath);
            return messageType;
        }
        catch (PartInitException e) {
            Activator.handleError(e, "An error occured while calling MetaData-View!", new Object[0]);
            return false;
        }
    }

    private Object call_COMPOSER_VIEW(String message) throws PartInitException {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        try {
            AggregationComposerEditorInput input = new AggregationComposerEditorInput(this.tgObj);
            AggregationComposerEditor cfr_ignored_0 = (AggregationComposerEditor)activePage.openEditor((IEditorInput)input, "info.textgrid.lab.core.aggregations.ui.editor");
        }
        catch (PartInitException e) {
            Activator.handleError(e, "An error occured while calling Composer-Editor!", new Object[0]);
        }
        return message;
    }

    public void setTGPublishClient() {
        try {
            this.publishClient = new PublishClient(ConfClient.getInstance().getValue("tgpublish"), this.sid);
        }
        catch (OfflineException offlineException) {
            Status status = new Status(4, "info.textgrid.lab.tgsearch.client.gui", "System offline, can not connect to TG-Publish.");
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void Log(String logString) {
        if (this.showLogs) {
            System.out.println(logString);
        }
    }

    public void ErrorLog(String logString) {
        if (this.showLogs) {
            System.err.println(logString);
        }
    }

    public String toString() {
        return "";
    }

    public void initialize() {
        this.allData.clear();
        this.isReadyForPublishing = false;
        this.isWorldReadable = false;
        this.ignoreWarnings = false;
        this.okCounts = 0;
        this.warningCounts = 0;
        this.errorCounts = 0;
        this.tgObj = null;
        this.uri = "";
    }

    public void toggleAll() {
        this.isReadyForPublishing = true;
    }

    public void test() {
        JAXB.marshal((Object)this.publishResponse, (OutputStream)System.out);
        this.Log("\npublishStatus : " + this.publishResponse.getPublishStatus().processStatus);
    }

    public static void main(String[] args) {
        TGPublishController controller = TGPublishController.getInstance();
        controller.callTGPublishClient("Publish");
        controller.test();
    }

    private static enum ActionError {
        NOT_SPECIFIED,
        AUTH,
        WRONG_CONTENT_TYPE,
        NO_PUBLISH_RIGHT,
        PID_GENERATION_FAILED,
        MISSING_METADATA,
        ALREADY_PUBLISHED,
        METADATA_WARNINGS_EXIST,
        SERVER_ERROR;

    }
}

