/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.tgpublish.client.gui.tester;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.tgpublish.client.gui.Activator;
import info.textgrid.middleware.tgpublish.api.jaxb.WorldReadableMimetypes;
import info.textgrid.middleware.tgpublish.client.PublishClient;
import java.util.ArrayList;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class IsPublishableObject
extends PropertyTester {
    private PublishClient publishClient = null;
    private String SID = RBACSession.getInstance().getSID(false);
    private WorldReadableMimetypes wRMimeTypes = null;

    public IsPublishableObject() {
        if (!this.SID.equals("")) {
            try {
                this.publishClient = new PublishClient(ConfClient.getInstance().getValue("tgpublish"), this.SID);
                this.wRMimeTypes = this.publishClient.getWorldReadables();
            }
            catch (Exception e) {
                Status status = new Status(4, "info.textgrid.lab.tgsearch.client.gui", "System offline, can not connect to TG-Publish.", (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (this.wRMimeTypes == null) {
            return false;
        }
        if (receiver != null && receiver instanceof TGObjectReference) {
            return this.isOK((TextGridObject)AdapterUtils.getAdapter((Object)receiver, TextGridObject.class));
        }
        return false;
    }

    private boolean isOK(TextGridObject tgo) {
        String contentTypeId = "";
        try {
            contentTypeId = tgo.getContentTypeID();
            if ((this.isWorldReadable(contentTypeId) || contentTypeId.contains("tg.edition") || contentTypeId.contains("tg.collection")) && !tgo.isPublic()) {
                return true;
            }
        }
        catch (CoreException e) {
            Activator.handleWarning(e, "Couldn't get the content type id of the selected textgrid object");
        }
        return false;
    }

    private boolean isWorldReadable(String contentTypeId) {
        ArrayList contTypeList = (ArrayList)this.wRMimeTypes.getWorldReadableList();
        for (String wRcontType : contTypeList) {
            if (!contentTypeId.matches(wRcontType)) continue;
            return true;
        }
        return false;
    }
}

