/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout;

import com.logabit.xlayout.Messages;
import com.logabit.xlayout.ParseException;
import com.logabit.xlayout.source.XLayoutSource;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.eclipse.osgi.util.NLS;

public class CachedDocumentFactory {
    private static Map<Object, CachedEntity> documentCache = new HashMap<Object, CachedEntity>();

    public static Document getDocument(XLayoutSource source) {
        Document document = null;
        CachedEntity entity = documentCache.get(source.getCachingKey());
        if (entity == null) {
            document = CachedDocumentFactory.loadDocument(source);
            entity = new CachedEntity(document, source.lastModified());
            documentCache.put(source.getCachingKey(), entity);
        } else if (entity.needsParsing(source)) {
            document = CachedDocumentFactory.loadDocument(source);
            entity.setDocument(document, source.lastModified());
        } else {
            document = entity.getDocument();
        }
        return document;
    }

    protected static Map<Object, CachedEntity> getDocumentCache() {
        return documentCache;
    }

    private static Document loadDocument(XLayoutSource source) throws ParseException {
        Document doc;
        SAXReader reader = new SAXReader();
        try {
            doc = reader.read(source.toSAXInputSource());
        }
        catch (DocumentException e) {
            throw new ParseException(NLS.bind((String)Messages.CachedDocumentFactory_parseError, (Object)source.getHint(), (Object)e.getMessage()), e);
        }
        return doc;
    }

    public static void clearCache() {
        documentCache.clear();
    }

    static class CachedEntity {
        private Document document;
        private long lastModified;

        public CachedEntity(Document doc, long lastModified) {
            this.lastModified = lastModified;
            this.document = doc;
        }

        public void setDocument(Document document, long lastModified) {
            this.document = document;
            this.lastModified = lastModified;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public Document getDocument() {
            return this.document;
        }

        public boolean needsParsing(XLayoutSource source) {
            return source.lastModified() != this.lastModified;
        }
    }
}

