/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout;

import com.logabit.xlayout.ControlHandlerConfigurationException;
import com.logabit.xlayout.handlers.IControlHandler;
import com.logabit.xlayout.utils.ConvertHelper;
import com.logabit.xlayout.utils.InstanceHelper;
import org.eclipse.osgi.util.NLS;

public class ControlHandlerConfig {
    private String name;
    private String className;
    private String defaultStyleAsString = null;
    private int defaultStyle = 0;
    private IControlHandler handlerInstance;

    public ControlHandlerConfig(String name, String className, String defaultStyleAsString) {
        this(name, className);
        this.defaultStyleAsString = defaultStyleAsString;
        if (defaultStyleAsString != null) {
            this.defaultStyle = ConvertHelper.convertToSWTStyle(this.defaultStyleAsString, 0);
        }
    }

    public ControlHandlerConfig(String name, String className) {
        this.name = name;
        this.className = className;
    }

    public ControlHandlerConfig(String name, IControlHandler handler) {
        this.name = name;
        this.handlerInstance = handler;
        this.className = handler.getClass().getName();
    }

    public String getClassName() {
        return this.className;
    }

    protected IControlHandler getControlHandlerInstance(ClassLoader classLoader) {
        if (this.handlerInstance == null) {
            try {
                this.handlerInstance = (IControlHandler)InstanceHelper.createInstance(this.className, classLoader);
            }
            catch (Exception e) {
                throw new ControlHandlerConfigurationException(NLS.bind((String)"Could not create control handler instance '{0}'!", (Object)this.className), e);
            }
        }
        return this.handlerInstance;
    }

    public String getName() {
        return this.name;
    }

    public int getDefaultStyle() {
        return this.defaultStyle;
    }

    public String getDefaultStyleAsString() {
        return this.defaultStyleAsString;
    }
}

