/*
 * Decompiled with CFR 0.152.
 */
package com.logabit.xlayout.source;

import com.logabit.xlayout.ParseException;
import com.logabit.xlayout.source.XLayoutSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.osgi.util.NLS;

public class XLayoutSourceResolver {
    private ClassLoader resourceClassLoader;
    private Class relativeClass;

    public XLayoutSourceResolver(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    public XLayoutSourceResolver(Class relativeClass) {
        this.resourceClassLoader = relativeClass.getClassLoader();
        this.relativeClass = relativeClass;
    }

    public XLayoutSourceResolver(Object relativeObject) {
        this(relativeObject.getClass());
    }

    public XLayoutSource resolve(String uriString) {
        InputStream is;
        String hint;
        if (uriString.startsWith("classpath:/")) {
            hint = uriString.substring(11);
            is = this.resourceClassLoader.getResourceAsStream(hint);
            if (is == null) {
                throw new ParseException(NLS.bind((String)"Classpath resource not found: '{0}'!", (Object)hint));
            }
        } else if (uriString.startsWith("./")) {
            hint = uriString.substring(2);
            is = this.relativeClass.getResourceAsStream(hint);
            if (is == null) {
                throw new ParseException(NLS.bind((String)"Classpath resource not found: '{0}'!", (Object)hint));
            }
        } else {
            File file = new File(uriString);
            try {
                FileInputStream is2 = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ParseException(NLS.bind((String)"Could not resolve file : '{0}'!", (Object)file.getAbsolutePath()), e);
            }
            return new XLayoutSource(file);
        }
        return new XLayoutSource(hint, is);
    }
}

