/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.basicMetadata.wizard;

import info.textgrid.lab.core.metadataeditor.basicMetadata.wizard.BasicMetadataWizard;
import info.textgrid.lab.core.metadataeditor.basicMetadata.wizard.BasicMetadataWizardSelected;
import info.textgrid.lab.core.metadataeditor.basicMetadata.wizard.IBasicMetadataWizardPage;
import info.textgrid.lab.core.metadataeditor.basicMetadata.wizard.Messages;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PageOne
extends WizardPage
implements IWizardPage,
IBasicMetadataWizardPage,
ISelectionChangedListener {
    private Composite container = null;
    private TableViewer projectViewer;
    private ComboViewer typeViewer;
    private Label projectDescLabel;
    private Wizard wizard = null;
    private TextGridProject project = null;
    private TextGridProject currentSelectedProject = null;
    private String objectType = "item";
    private static String[] OBJECT_TYPES = new String[]{"item", "work", "edition", "collection"};

    protected PageOne() {
        this(null);
    }

    public PageOne(TextGridProject project) {
        super(Messages.PageOne_title);
        this.setTitle(Messages.PageOne_title);
        this.currentSelectedProject = project;
    }

    @Override
    public void init(Wizard wizard) {
        this.wizard = wizard;
    }

    private void createProjectGroup(Composite control) {
        Group projectGroup = new Group(control, 16);
        projectGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        projectGroup.setLayout((Layout)new GridLayout(1, true));
        projectGroup.setText("");
        this.projectViewer = new TableViewer((Composite)projectGroup, 268438276);
        GridData projectTreeData = new GridData(4, 4, true, true);
        projectTreeData.heightHint = 200;
        this.projectViewer.getTable().setLayoutData((Object)projectTreeData);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new TGODefaultLabelProvider(true));
        this.projectDescLabel = new Label((Composite)projectGroup, 64);
        GridData projectDescData = new GridData(4, 4, true, false);
        projectDescData.heightHint = 48;
        this.projectDescLabel.setLayoutData((Object)projectDescData);
        UpdatingDeferredListContentProvider contentProvider = new UpdatingDeferredListContentProvider();
        this.projectViewer.setContentProvider((IContentProvider)contentProvider);
        this.projectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.PROJECT_LEADER));
        this.projectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.currentSelectedProject != null) {
            contentProvider.addDoneListener(new DeferredListContentProvider.IDoneListener(){

                public void loadDone(Viewer viewer) {
                    StructuredSelection sel = new StructuredSelection((Object)PageOne.this.currentSelectedProject);
                    PageOne.this.projectViewer.setSelection((ISelection)sel, true);
                    if (sel.equals(PageOne.this.projectViewer.getSelection())) {
                        PageOne.this.setPageComplete(true);
                    } else {
                        PageOne.this.setPageComplete(false);
                    }
                }
            });
        } else {
            this.setPageComplete(false);
        }
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.container.setLayout((Layout)new GridLayout(1, false));
        Label intro = new Label(this.container, 64);
        intro.setLayoutData((Object)new GridData(4, 128, true, false));
        intro.setText(Messages.PageOne_createInfo);
        this.setControl((Control)this.container);
        this.createProjectGroup(this.container);
        Group typeGroup = new Group(this.container, 0);
        typeGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        typeGroup.setLayout((Layout)new GridLayout(1, false));
        typeGroup.setText(Messages.PageOne_type);
        Combo typeControl = new Combo((Composite)typeGroup, 12);
        typeControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.typeViewer = new ComboViewer(typeControl);
        this.typeViewer.add((Object[])OBJECT_TYPES);
        this.typeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.typeViewer.setSelection((ISelection)new StructuredSelection((Object)"item"));
    }

    public Control getControl() {
        return this.container;
    }

    @Override
    public void finishPage() {
        if (this.wizard instanceof BasicMetadataWizard) {
            ((BasicMetadataWizard)this.wizard).setSelectedProjectType(this.project, this.objectType);
        } else {
            ((BasicMetadataWizardSelected)this.wizard).setSelectedProjectType(this.project, this.objectType);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.projectViewer) {
            Object selectedObject = null;
            if (event.getSelection() instanceof IStructuredSelection) {
                selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
            }
            if (selectedObject instanceof TextGridProject) {
                this.project = (TextGridProject)selectedObject;
                this.projectDescLabel.setText(NLS.bind((String)"{0} ({1})", (Object)this.project.getDescription(), (Object)this.project.getId()));
                this.setPageComplete(true);
            } else {
                this.project = null;
                this.projectDescLabel.setText("");
            }
        } else if (event.getSelectionProvider() == this.typeViewer) {
            Object selectedObject = null;
            if (event.getSelection() instanceof IStructuredSelection) {
                selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
            }
            this.objectType = selectedObject instanceof String ? (String)selectedObject : null;
        }
    }
}

