/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableControl;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.dom4j.Element;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CustomControlElement
implements IRepresentableComposite {
    private Composite section = null;
    private String id = null;
    private Element dataElement = null;
    private ArrayList<IControl> controls = new ArrayList();

    public CustomControlElement(String id, ScrolledForm f, Control section, Element element) {
        this.id = id;
        this.section = (Composite)section;
        this.dataElement = element;
    }

    public Composite getBody() {
        return this.section;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void addControlElement(IControl elem) {
        this.controls.add(elem);
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        for (IControl con : this.controls) {
            con.createOMElement(omFactory, parent, ns, asAttribute);
        }
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        boolean found = false;
        for (IControl con : this.controls) {
            found |= con.setOMElement(root, tg);
        }
        return found;
    }

    @Override
    public void dispose() {
        for (IControl c : this.controls) {
            c.dispose();
        }
    }

    @Override
    public boolean validate() {
        boolean valid = true;
        for (IControl c : this.getControls()) {
            valid &= c.validate();
        }
        return valid;
    }

    @Override
    public List<Control> getSWTControls() {
        ArrayList<Control> controls = new ArrayList<Control>();
        for (IControl con : this.controls) {
            if (con instanceof IRepresentableControl) {
                controls.add(((IRepresentableControl)con).getSWTControl());
                continue;
            }
            if (!(con instanceof IRepresentableComposite)) continue;
            controls.addAll(((IRepresentableComposite)con).getSWTControls());
        }
        return controls;
    }

    @Override
    public List<IControl> getControls() {
        return this.controls;
    }

    @Override
    public IRepresentableComposite getUnit() {
        return this;
    }

    @Override
    public void clear() {
        for (IControl c : this.controls) {
            c.clear();
        }
    }

    @Override
    public void setExpanded(boolean expand) {
    }

    @Override
    public boolean isExpanded() {
        return false;
    }
}

