/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.utils;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.utils.Messages;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.utils.ProjectNavigator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FetchTGObjectsDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private Text text = null;
    private ProjectNavigator viewer = null;
    private TextGridObject selectedObject = null;

    public FetchTGObjectsDialog(Shell parentShell) {
        super(parentShell);
    }

    public static void openDialog(Text text) {
        FetchTGObjectsDialog dialog = new FetchTGObjectsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.text = text;
        dialog.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(1, false));
        this.setTitle(Messages.FetchTGObjectsDialog_selectWorkObject_title);
        Label intro = new Label(control, 64);
        intro.setLayoutData((Object)new GridData(4, 128, true, false));
        intro.setText(Messages.FetchTGObjectsDialog_selectWorkObject_desc);
        this.createObjectsGroup(control);
        return control;
    }

    private void createObjectsGroup(Composite control) {
        Group objectsGroup = new Group(control, 16);
        objectsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        objectsGroup.setLayout((Layout)new GridLayout(1, true));
        GridData projectTreeData = new GridData(4, 4, true, true);
        projectTreeData.heightHint = 200;
        objectsGroup.setLayoutData((Object)projectTreeData);
        this.viewer = new ProjectNavigator((Composite)objectsGroup);
        this.viewer.getControl().setLayoutData((Object)projectTreeData);
        this.viewer.setWorkFilter();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.viewer) {
            Object object = null;
            if (event.getSelection() instanceof IStructuredSelection) {
                object = ((IStructuredSelection)event.getSelection()).getFirstElement();
            }
            if (object != null) {
                this.selectedObject = (TextGridObject)AdapterUtils.getAdapter((Object)object, TextGridObject.class);
                try {
                    if (this.selectedObject == null || !"text/tg.work+xml".equals(this.selectedObject.getContentTypeID())) {
                        this.selectedObject = null;
                        this.setErrorMessage(Messages.FetchTGObjectsDialog_selectWorkObject_error);
                        return;
                    }
                }
                catch (CoreException e1) {
                    Activator.handleError(e1);
                    return;
                }
                this.setErrorMessage(null);
                try {
                    this.setMessage(NLS.bind((String)Messages.FetchTGObjectsDialog_selectedWorkObject, (Object)this.selectedObject.getNameCandidate()));
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
            } else {
                this.setErrorMessage(Messages.FetchTGObjectsDialog_selectWorkObject_error);
            }
        }
    }

    protected void okPressed() {
        if (this.selectedObject != null) {
            this.text.setText(this.selectedObject.getURI().toString());
            super.okPressed();
        }
    }
}

