/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.middleware.tgpublish.api.jaxb;

import info.textgrid.middleware.tgpublish.api.jaxb.ErrorType;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishError;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishWarning;
import info.textgrid.middleware.tgpublish.api.jaxb.ReferencedUris;
import info.textgrid.middleware.tgpublish.api.jaxb.StatusType;
import info.textgrid.middleware.tgpublish.api.jaxb.WarningType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

public class PublishObject {
    private static final String OUTSIDE_REFERENCES_WARNING_STRING = "There are URIs referenced in some objects, that are not part of the object to publish";
    @XmlAttribute
    public String uri;
    @XmlAttribute
    public String pid;
    @XmlAttribute
    public StatusType status = StatusType.OK;
    private List<PublishError> errors = new ArrayList<PublishError>();
    private List<PublishWarning> warnings = new ArrayList<PublishWarning>();
    private ReferencedUris referencedUris;

    public PublishObject() {
    }

    public PublishObject(String uri) {
        this();
        this.uri = uri;
    }

    public void addError(ErrorType type, String message) {
        PublishError e = new PublishError(type, message);
        this.errors.add(e);
        this.changeStatus(StatusType.ERROR);
    }

    public void setErrors(List<PublishError> errors) {
        this.errors = errors;
        this.changeStatus(StatusType.ERROR);
    }

    @XmlElement(name="error")
    public List<PublishError> getErrors() {
        return this.errors;
    }

    public void addWarning(WarningType type, String message) {
        PublishWarning e = new PublishWarning(type, message);
        this.warnings.add(e);
        this.changeStatus(StatusType.WARNING);
    }

    public void setWarnings(List<PublishWarning> warnings) {
        this.warnings = warnings;
        this.changeStatus(StatusType.WARNING);
    }

    @XmlElement(name="warning")
    public List<PublishWarning> getWarnings() {
        return this.warnings;
    }

    private void changeStatus(StatusType newStatus) {
        if (this.status == StatusType.ERROR) {
            return;
        }
        if (newStatus == StatusType.OK) {
            return;
        }
        this.status = newStatus;
    }

    public void setReferencedUris(ReferencedUris referencedUris) {
        this.changeStatus(StatusType.WARNING);
        this.addWarning(WarningType.CHECK_REFERENCES, OUTSIDE_REFERENCES_WARNING_STRING);
        this.referencedUris = referencedUris;
    }

    public ReferencedUris getReferencedUris() {
        return this.referencedUris;
    }
}

