/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.tei;

import java.util.ArrayList;
import java.util.HashSet;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.editor.IOutlineProvider;
import net.sf.vex.editor.VexEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;

public class TEIOutlineProvider
implements IOutlineProvider {
    private final ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return TEIOutlineProvider.this.getOutlineChildren((IVexElement)parentElement);
        }

        public Object getParent(Object element) {
            IVexElement parent = ((IVexElement)element).getParent();
            if (parent == null) {
                return element;
            }
            return TEIOutlineProvider.this.getOutlineElement(parent);
        }

        public boolean hasChildren(Object element) {
            return TEIOutlineProvider.this.getOutlineChildren((IVexElement)element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            IVexDocument document = (IVexDocument)inputElement;
            return new Object[]{document.getRootElement()};
        }
    };
    private final ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object o) {
            IVexElement titleStmtChild;
            IVexElement fileDescChild;
            IVexElement e = (IVexElement)o;
            IVexElement titleChild = TEIOutlineProvider.this.findChild(e, "title");
            if (titleChild != null) {
                return titleChild.getText();
            }
            titleChild = TEIOutlineProvider.this.findChild(e, "head");
            if (titleChild != null) {
                return titleChild.getText();
            }
            IVexElement teiHeaderChild = TEIOutlineProvider.this.findChild(e, "teiHeader");
            if (teiHeaderChild != null && (fileDescChild = TEIOutlineProvider.this.findChild(teiHeaderChild, "fileDesc")) != null && (titleStmtChild = TEIOutlineProvider.this.findChild(fileDescChild, "titleStmt")) != null && (titleChild = TEIOutlineProvider.this.findChild(titleStmtChild, "title")) != null) {
                return titleChild.getText();
            }
            return e.getName();
        }
    };
    private static final int MAPSIZE = 101;
    private static final HashSet titledElements = new HashSet(101);

    static {
        titledElements.add("TEI.2");
        titledElements.add("div1");
        titledElements.add("div2");
        titledElements.add("div3");
        titledElements.add("div4");
        titledElements.add("div5");
        titledElements.add("body");
        titledElements.add("text");
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public IVexElement getOutlineElement(IVexElement child) {
        IVexElement element = child;
        while (element.getParent() != null && !this.isTitledElement(element)) {
            element = element.getParent();
        }
        return element;
    }

    public void init(VexEditor editor) {
    }

    private IVexElement[] getOutlineChildren(IVexElement element) {
        ArrayList<IVexElement> children = new ArrayList<IVexElement>();
        IVexElement[] childElements = element.getChildElements();
        int i = 0;
        while (i < childElements.length) {
            if (titledElements.contains(childElements[i].getName())) {
                children.add(childElements[i]);
            }
            ++i;
        }
        return children.toArray(new IVexElement[children.size()]);
    }

    private boolean isTitledElement(IVexElement e) {
        IVexElement[] children;
        return (titledElements.contains(e.getName()) || e.getParent() == null) && ((children = e.getChildElements()).length > 0 && children[0].getName().equals("title") || children.length > 1 && children[1].getName().equals("title") || children.length > 0 && children[0].getName().equals("head") || children.length > 1 && children[1].getName().equals("head"));
    }

    private IVexElement findChild(IVexElement parent, String childName) {
        IVexElement[] children = parent.getChildElements();
        int i = 0;
        while (i < children.length) {
            IVexElement child = children[i];
            if (child.getName().equals(childName)) {
                return child;
            }
            ++i;
        }
        return null;
    }
}

