/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.cxf.ws.policy.PolicyVerificationInInterceptor;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

public class PolicyInInterceptor
extends AbstractPolicyInterceptor {
    public static final PolicyInInterceptor INSTANCE = new PolicyInInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyInInterceptor.class);

    public PolicyInInterceptor() {
        super("org.apache.cxf.ws.policy.PolicyInInterceptor", "receive");
    }

    protected void handle(Message msg) {
        Object ep;
        Collection<Assertion> assertions;
        List<Interceptor<? extends Message>> interceptors;
        Exchange exchange = msg.getExchange();
        Bus bus = exchange.get(Bus.class);
        Endpoint e = exchange.get(Endpoint.class);
        if (null == e) {
            LOG.fine("No endpoint.");
            return;
        }
        EndpointInfo ei = e.getEndpointInfo();
        PolicyEngine pe = bus.getExtension(PolicyEngine.class);
        if (null == pe) {
            return;
        }
        Policy p = (Policy)msg.getContextualProperty("org.apache.cxf.ws.policy.override");
        if (p != null) {
            EndpointPolicyImpl endpi = new EndpointPolicyImpl(p);
            EffectivePolicyImpl effectivePolicy = new EffectivePolicyImpl();
            effectivePolicy.initialise(endpi, (PolicyEngineImpl)pe, true);
            msg.put(EffectivePolicy.class, effectivePolicy);
            PolicyUtils.logPolicy(LOG, Level.FINEST, "Using effective policy: ", (PolicyComponent)effectivePolicy.getPolicy());
            interceptors = effectivePolicy.getInterceptors();
            for (Interceptor<? extends Message> i : interceptors) {
                msg.getInterceptorChain().add(i);
                LOG.log(Level.FINE, "Added interceptor of type {0}", i.getClass().getSimpleName());
            }
            assertions = effectivePolicy.getChosenAlternative();
            if (null != assertions && !assertions.isEmpty()) {
                msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
                msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
            }
        }
        if (MessageUtils.isRequestor(msg)) {
            BindingOperationInfo boi = exchange.get(BindingOperationInfo.class);
            if (boi == null) {
                Collection<Assertion> assertions2;
                Conduit conduit = exchange.getConduit(msg);
                EndpointPolicy ep2 = pe.getClientEndpointPolicy(ei, conduit);
                List<Interceptor<? extends Message>> interceptors2 = ep2.getInterceptors();
                if (null != interceptors2) {
                    for (Interceptor<? extends Message> i : interceptors2) {
                        msg.getInterceptorChain().add(i);
                    }
                }
                if (null != (assertions2 = ep2.getVocabulary()) && !assertions2.isEmpty()) {
                    msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions2));
                    msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
                }
            } else {
                ep = pe.getEffectiveClientResponsePolicy(ei, boi);
                interceptors = ep.getInterceptors();
                if (null != interceptors) {
                    for (Interceptor<? extends Message> i : interceptors) {
                        msg.getInterceptorChain().add(i);
                    }
                }
                if (ep.getPolicy() != null) {
                    msg.put(AssertionInfoMap.class, new AssertionInfoMap(ep.getPolicy()));
                    msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
                }
            }
        } else {
            Destination destination = exchange.getDestination();
            ep = pe.getServerEndpointPolicy(ei, destination);
            interceptors = ep.getInterceptors();
            if (null != interceptors) {
                for (Interceptor<? extends Message> i : interceptors) {
                    msg.getInterceptorChain().add(i);
                    LOG.log(Level.FINE, "Added interceptor of type {0}", i.getClass().getSimpleName());
                }
            }
            if (null != (assertions = ep.getVocabulary()) && !assertions.isEmpty()) {
                msg.put(AssertionInfoMap.class, new AssertionInfoMap(assertions));
                msg.getInterceptorChain().add(PolicyVerificationInInterceptor.INSTANCE);
            }
        }
    }
}

