/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.configurators;

import info.textgrid._import.RewriteMethod;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.importexport.configurators.DirectoryAggregationSupplier;
import info.textgrid.lab.core.importexport.configurators.ListAggregationSupplier;
import info.textgrid.lab.core.importexport.configurators.Messages;
import info.textgrid.lab.core.importexport.model.AbstractImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.IExportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.IImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.RewriteSetup;
import info.textgrid.lab.core.model.AggregationReader;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class AggregationConfigurator
extends AbstractImportEntryConfigurator
implements IImportEntryConfigurator,
IExportEntryConfigurator {
    private static final String REWRITE_URL = "internal:textgrid#aggregation";

    @Override
    public void configureImport(ImportEntry entry, IProgressMonitor monitor) {
        SubMonitor progress;
        block13: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
            try {
                File workfile;
                String work;
                if (!this.isAggregation(entry.getObject())) break block13;
                entry.setRewriteSetup(RewriteSetup.of(RewriteMethod.XML, REWRITE_URL));
                File file = entry.getLocalFile();
                progress.setTaskName(NLS.bind((String)Messages.AggregationConfigurator_Adding_Children, (Object)entry.getLocalData()));
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    entry.setSupplier(new DirectoryAggregationSupplier(file, entry));
                    progress.worked(20);
                    if (progress.isCanceled()) {
                        return;
                    }
                    progress.setWorkRemaining(10 * files.length + 10);
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        entry.addFile(child, (IProgressMonitor)progress.newChild(10));
                        ++n2;
                    }
                } else {
                    try {
                        List uris = AggregationReader.read((Source)new StreamSource(file), (boolean)false);
                        progress.worked(20);
                        if (progress.isCanceled()) {
                            return;
                        }
                        progress.setWorkRemaining(uris.size() * 10 + 10);
                        for (URI uri : uris) {
                            if (uri.isAbsolute()) {
                                StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.AggregationConfigurator_Unknown_Aggregated_Resource, (Object)entry.getLocalData(), (Object)uri)));
                                progress.worked(10);
                                continue;
                            }
                            String path = uri.getPath();
                            if (path == null) continue;
                            File child = new File(file.getParent(), path);
                            entry.addFile(child, (IProgressMonitor)progress.newChild(10));
                            if (!progress.isCanceled()) continue;
                            return;
                        }
                        entry.setSupplier(new ListAggregationSupplier(file, uris, entry));
                    }
                    catch (XMLStreamException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.AggregationConfigurator_AggregationParseFailed, (Object)file), (Throwable)e), 3);
                    }
                    catch (URISyntaxException e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.AggregationConfigurator_AggregationParseFailed, (Object)file), (Throwable)e), 3);
                    }
                }
                if (entry.getObject().getMetadata().getEdition() != null && (work = entry.getObject().getMetadata().getEdition().getIsEditionOf()) != null && !"".equals(work) && (workfile = new File(file.getParent(), work)).exists()) {
                    entry.getModel().addFile(workfile, (IProgressMonitor)progress.newChild(10));
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
            }
        }
        progress.done();
    }

    private boolean isAggregation(TextGridObject object) {
        try {
            return object.getContentType(false).getId().contains("aggregation");
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
            return false;
        }
    }

    @Override
    public void configureExport(ImportEntry entry, IProgressMonitor monitor) {
        if (this.isAggregation(entry.getObject())) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
            entry.setRewriteSetup(RewriteSetup.of(RewriteMethod.XML, REWRITE_URL));
            File dir = new File(FilenameUtils.removeExtension((String)entry.getLocalData()));
            Aggregation aggregation = (Aggregation)AdapterUtils.getAdapter((Object)entry.getObject(), Aggregation.class);
            progress.worked(10);
            TGObjectReference[] references = new TGObjectReference[]{};
            if (aggregation != null) {
                references = (TGObjectReference[])AdapterUtils.getAdapters((Object[])aggregation.getChildren(), TGObjectReference.class, (boolean)false);
                progress.worked(20);
            } else {
                IFile file = (IFile)AdapterUtils.getAdapter((Object)entry.getObject(), IFile.class);
                progress.worked(10);
                try {
                    InputStream contents = file.getContents();
                    List uris = AggregationReader.read((Source)new StreamSource(contents), (boolean)false);
                    progress.worked(20);
                    Iterator iterator = uris.iterator();
                    references = new TGObjectReference[uris.size()];
                    int i = 0;
                    while (i < references.length) {
                        references[i] = new TGObjectReference((URI)iterator.next());
                        ++i;
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                }
                catch (XMLStreamException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", MessageFormat.format(Messages.AggregationConfigurator_Error_reading_aggregation, entry.getObject(), e.getMessage()), (Throwable)e));
                }
                catch (URISyntaxException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", MessageFormat.format(Messages.AggregationConfigurator_Aggregation_invalid_URI, entry.getObject(), e.getMessage()), (Throwable)e));
                }
            }
            progress.setWorkRemaining(100 * references.length + 100);
            TGObjectReference[] tGObjectReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                TGObjectReference reference = tGObjectReferenceArray[n2];
                entry.addObject(reference, dir, (IProgressMonitor)progress.newChild(100));
                ++n2;
            }
            try {
                String work;
                if (entry.getObject().getMetadata().getEdition() != null && (work = entry.getObject().getMetadata().getEdition().getIsEditionOf()) != null && !"".equals(work)) {
                    entry.getModel().addObject(new TGObjectReference(URI.create(work)), (IProgressMonitor)progress.newChild(100));
                }
            }
            catch (CrudServiceException e) {
                StatusManager.getManager().handle((CoreException)((Object)e), "info.textgrid.lab.core.importexport");
            }
        }
    }
}

