/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.protocol.textgrid;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.protocol.textgrid.Messages;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ObjectNotFoundFault;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class TextGridLabURLConnection
extends URLConnection {
    private TextGridObject textGridObject;
    private IFile file;

    public TextGridLabURLConnection(URL url) {
        super(url);
    }

    @Override
    public void connect() throws IOException {
        try {
            this.textGridObject = TextGridObject.getInstance((URI)this.getURL().toURI(), (boolean)true);
            this.file = (IFile)AdapterUtils.getAdapter((Object)this.textGridObject, IFile.class);
        }
        catch (CrudServiceException e) {
            if (e.getCause() != null && e.getCause() instanceof ObjectNotFoundFault) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException(MessageFormat.format(Messages.TextGridLabURLConnection_xDoesNotExist, this.getURL()));
                fileNotFoundException.initCause(e);
                throw fileNotFoundException;
            }
            throw new IOException(MessageFormat.format(Messages.TextGridLabURLConnection_FailedToAccessUri, this.getURL(), e.getLocalizedMessage()));
        }
        catch (URISyntaxException e) {
            throw new IOException(MessageFormat.format(Messages.TextGridLabURLConnection_InvalidTGURI, this.getURL(), e.getLocalizedMessage()), e);
        }
    }

    @Override
    public String getHeaderField(String name) {
        if (this.textGridObject == null) {
            throw new IllegalStateException("Need to connect first.");
        }
        try {
            if (name.equalsIgnoreCase("content-type")) {
                return this.textGridObject.getContentTypeID();
            }
            if (name.equalsIgnoreCase("last-modified")) {
                return this.textGridObject.getLastModified().getTime().toString();
            }
            if (name.equalsIgnoreCase("date")) {
                return this.textGridObject.getMetadataForReading().getGeneric().getGenerated().getCreated().toString();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return super.getHeaderField(name);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.file == null) {
            this.connect();
        }
        try {
            return this.file.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }
}

