/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.TeiFactory;

import info.textgrid.lab.linkeditor.controller.TeiFactory.IElement;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEIDocFactory;
import info.textgrid.lab.linkeditor.model.links.ILink;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.osgi.util.NLS;

public class TEILink
implements IElement {
    private String refId;
    private ILink link;
    private String parentPath = null;

    public TEILink(String refId, ILink link) {
        this.refId = refId;
        this.link = link;
    }

    public TEILink(String refId, ILink link, String parentPath) {
        this.refId = refId;
        this.link = link;
        this.parentPath = parentPath;
    }

    public ILink getLink() {
        return this.link;
    }

    @Override
    public OMElement createOMElement(OMFactory factory, OMElement parent, OMNamespace ns) {
        OMElement linkElem = factory.createOMElement("link", ns, (OMContainer)parent);
        if (!"".equals(this.link.getEndAnchorId())) {
            linkElem.addAttribute("targets", NLS.bind((String)"#{0} {1}#{2} {1}#{3}", (Object[])new Object[]{this.refId, TEIDocFactory.getRelativeUri(this.link.getTextUri(), this.parentPath), this.link.getStartAnchorId(), this.link.getEndAnchorId()}), null);
        } else {
            linkElem.addAttribute("targets", NLS.bind((String)"#{0} {1}#{2}", (Object[])new Object[]{this.refId, TEIDocFactory.getRelativeUri(this.link.getTextUri(), this.parentPath), this.link.getStartAnchorId()}), null);
        }
        return linkElem;
    }
}

