/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.TeiFactory;

import info.textgrid.lab.linkeditor.controller.TeiFactory.IElement;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGGroup;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEILink;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;

public class TEILinkGroup
implements IElement {
    private String id;
    private String type = "text-image-links";
    private SVGGroup svgGrp;
    private List<TEILink> links;

    public TEILinkGroup(String id) {
        this.id = id;
        this.links = Collections.synchronizedList(new ArrayList());
    }

    public TEILinkGroup(String id, String type) {
        this(id);
        this.type = type;
    }

    public TEILinkGroup(String id, String type, SVGGroup grp) {
        this(id, type);
        this.svgGrp = grp;
    }

    public TEILinkGroup(String id, SVGGroup grp) {
        this(id);
        this.svgGrp = grp;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SVGGroup getSvgGrp() {
        return this.svgGrp;
    }

    public void setSvgGrp(SVGGroup svgGrp) {
        this.svgGrp = svgGrp;
    }

    public List<TEILink> getLinks() {
        return this.links;
    }

    public void setLinks(List<TEILink> links) {
        this.links = links;
    }

    public boolean addLink(TEILink link) {
        return this.links.add(link);
    }

    public boolean removeLink(TEILink link) {
        return this.links.remove(link);
    }

    @Override
    public OMElement createOMElement(OMFactory factory, OMElement parent, OMNamespace ns) {
        OMElement linkGrp = factory.createOMElement("linkGrp", ns, (OMContainer)parent);
        linkGrp.addAttribute("id", this.id, parent.findNamespaceURI("xml"));
        linkGrp.addAttribute("type", this.type, null);
        linkGrp.addAttribute("facs", "#" + this.svgGrp.getId(), null);
        for (TEILink l : this.links) {
            l.createOMElement(factory, linkGrp, ns);
        }
        return linkGrp;
    }
}

