/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.dialogs;

import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.core.swtutils.PendingLabelProvider;
import info.textgrid.lab.linkeditor.controller.LinkEditorController;
import info.textgrid.lab.linkeditor.controller.utils.UpdatingDeferredListContentProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelectNameLocationDialog
extends TitleAreaDialog
implements ISelectionChangedListener {
    private ListViewer projectViewer;
    private TextGridProject currentProject;
    private TextGridProject project = null;
    private Label projectDescLabel;
    private Text name_text = null;
    private LinkEditorController controller = null;
    private boolean saveAs = false;
    private boolean createButtons = true;

    public static void openDialog(LinkEditorController controller, boolean saveAs) {
        SelectNameLocationDialog dialog = new SelectNameLocationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.controller = controller;
        dialog.saveAs = saveAs;
        dialog.open();
    }

    protected SelectNameLocationDialog(Shell parentShell) {
        super(parentShell);
    }

    private void updateLinkEditorController() {
        this.controller.updateDataFromSelectNameLocationDialog(this.project, this.name_text.getText());
    }

    private boolean isValidData() {
        boolean nameRes;
        boolean projectRes = this.project != null;
        boolean bl = nameRes = !this.name_text.getText().equals("");
        if (!projectRes && !nameRes) {
            this.setErrorMessage("Please select a project to save in and enter a title for the new object!");
        } else if (!projectRes) {
            this.setErrorMessage("Please select a project to save in!");
        } else {
            this.setErrorMessage("Please  enter a title for the new object!");
        }
        return projectRes && nameRes;
    }

    public TextGridProject getSelectedProject() {
        return this.project;
    }

    public String getEnteredTitle() {
        return this.name_text.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(1, false));
        this.getShell().setText("Save changes");
        this.setTitle("Save Text-Image-Link Object");
        Label intro = new Label(control, 64);
        intro.setLayoutData((Object)new GridData(4, 128, true, false));
        intro.setText("To save the changes in a new Object, please select a project to save in and enter a title for the new object.");
        this.createProjectGroup(control);
        this.createNameGroup(control);
        this.createButtonBar(control);
        this.createButtons = false;
        if (!this.saveAs) {
            this.createSaveLocalGroup(control);
        }
        return control;
    }

    protected Control createButtonBar(Composite parent) {
        if (this.createButtons) {
            return super.createButtonBar(parent);
        }
        return null;
    }

    protected void okPressed() {
        if (this.isValidData()) {
            this.updateLinkEditorController();
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.project = null;
        this.updateLinkEditorController();
        super.cancelPressed();
    }

    private void cancelPressed2() {
        super.cancelPressed();
    }

    private void createNameGroup(Composite control) {
        Group nameGroup = new Group(control, 16);
        nameGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        nameGroup.setLayout((Layout)new GridLayout(1, true));
        nameGroup.setText("Title");
        this.name_text = new Text((Composite)nameGroup, 2048);
        this.name_text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createSaveLocalGroup(Composite control) {
        Group saveLocalGroup = new Group(control, 16);
        saveLocalGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        saveLocalGroup.setLayout((Layout)new GridLayout(1, true));
        saveLocalGroup.setText("Or save as local file:");
        Button saveLocal = new Button((Composite)saveLocalGroup, 2048);
        saveLocal.setText("Save as local file");
        saveLocal.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        saveLocal.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinkEditorController.getInstance().saveLocalAnnotatedFile(SelectNameLocationDialog.this.saveAs);
                SelectNameLocationDialog.this.cancelPressed2();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createProjectGroup(Composite control) {
        Group projectGroup = new Group(control, 16);
        projectGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        projectGroup.setLayout((Layout)new GridLayout(1, true));
        List list = new List((Composite)projectGroup, 268436228);
        GridData projectTreeData = new GridData(4, 4, true, true);
        projectTreeData.heightHint = 200;
        list.setLayoutData((Object)projectTreeData);
        this.projectDescLabel = new Label((Composite)projectGroup, 64);
        GridData projectDescData = new GridData(4, 4, true, false);
        projectDescData.heightHint = 48;
        this.projectDescLabel.setLayoutData((Object)projectDescData);
        this.projectViewer = new ListViewer(list);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new PendingLabelProvider());
        final UpdatingDeferredListContentProvider contentProvider = new UpdatingDeferredListContentProvider();
        this.projectViewer.setContentProvider((IContentProvider)contentProvider);
        this.projectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.EDITOR));
        this.projectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.currentProject != null) {
            contentProvider.addDoneListener(new DeferredListContentProvider.IDoneListener(){

                public void loadDone(Viewer viewer) {
                    SelectNameLocationDialog.this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)SelectNameLocationDialog.this.currentProject), true);
                    contentProvider.removeDoneListener(this);
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.projectViewer) {
            Object selectedObject = null;
            if (event.getSelection() instanceof IStructuredSelection) {
                selectedObject = ((IStructuredSelection)event.getSelection()).getFirstElement();
            }
            if (selectedObject instanceof TextGridProject) {
                this.project = (TextGridProject)selectedObject;
                this.projectDescLabel.setText(NLS.bind((String)"{0} ({1})", (Object)this.project.getDescription(), (Object)this.project.getId()));
            } else {
                this.project = null;
                this.projectDescLabel.setText("");
            }
        }
    }
}

