/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.tools;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.linkeditor.controller.TeiFactory.OMUtil;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEIDocFactory;
import info.textgrid.lab.linkeditor.tools.Activator;
import java.io.InputStream;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.jaxen.JaxenException;

public class ImportExportUtils {
    public static TGObjectAnalyzer getObjectAnalyzer(TextGridObject tgObject) {
        return new TGObjectAnalyzer(tgObject);
    }

    public static TGObjectAnalyzer getObjectAnalyzer(InputStream inputStream) {
        return new TGObjectAnalyzer(inputStream);
    }

    public static class TGObjectAnalyzer {
        private OMElement root = null;

        public TGObjectAnalyzer(TextGridObject tgObj) {
            try {
                IFile file = (IFile)tgObj.getAdapter(IFile.class);
                InputStream inputStream = file.getContents(true);
                this.root = new StAXOMBuilder(inputStream).getDocumentElement();
                if (!this.root.getLocalName().equals("TEI")) {
                    throw new RuntimeException("Error: Old style Text-Image-Link Object!");
                }
            }
            catch (Exception e) {
                Activator.handleError(e);
            }
        }

        public TGObjectAnalyzer(InputStream inputStream) {
            try {
                this.root = new StAXOMBuilder(inputStream).getDocumentElement();
                if (!this.root.getLocalName().equals("TEI")) {
                    throw new RuntimeException("Error: Old style Text-Image-Link Object!");
                }
            }
            catch (Exception e) {
                Activator.handleError(e);
            }
        }

        public String[] getTextUris() {
            TreeSet<String> resources = new TreeSet<String>();
            try {
                List linkElems = OMUtil.getElementListWithName((String)"link", (OMElement)this.root, (String)TEIDocFactory.TEI_NS_URI, (String)TEIDocFactory.TEI_NS_Prefix);
                for (OMElement e : linkElems) {
                    String textUri = this.getTextUriFromElement(e);
                    resources.add(textUri);
                }
            }
            catch (JaxenException e) {
                Activator.handleError(e);
            }
            catch (Exception e) {
                Activator.handleError(e);
            }
            return resources.toArray(new String[0]);
        }

        public String[] getImageUris() {
            TreeSet<String> resources = new TreeSet<String>();
            try {
                List imageElements = OMUtil.getElementListWithName((String)"image", (OMElement)this.root, (String)TEIDocFactory.SVG_NS_URI, (String)TEIDocFactory.SVG_NS_Prefix);
                for (OMElement e : imageElements) {
                    String imageUri = e.getAttributeValue(new QName(TEIDocFactory.XLINK_NS_URI, "href", TEIDocFactory.XLINK_NS_Prefix));
                    resources.add(imageUri);
                }
            }
            catch (JaxenException e) {
                Activator.handleError(e);
            }
            catch (Exception e) {
                Activator.handleError(e);
            }
            return resources.toArray(new String[0]);
        }

        public String[] getAllUris() {
            TreeSet<String> resources = new TreeSet<String>();
            try {
                List imageElements = OMUtil.getElementListWithName((String)"image", (OMElement)this.root, (String)TEIDocFactory.SVG_NS_URI, (String)TEIDocFactory.SVG_NS_Prefix);
                for (OMElement e : imageElements) {
                    String imageUri = e.getAttributeValue(new QName(TEIDocFactory.XLINK_NS_URI, "href", TEIDocFactory.XLINK_NS_Prefix));
                    resources.add(imageUri);
                }
                List linkElems = OMUtil.getElementListWithName((String)"link", (OMElement)this.root, (String)TEIDocFactory.TEI_NS_URI, (String)TEIDocFactory.TEI_NS_Prefix);
                for (OMElement e : linkElems) {
                    String textUri = this.getTextUriFromElement(e);
                    resources.add(textUri);
                }
            }
            catch (JaxenException e) {
                Activator.handleError(e);
            }
            catch (Exception e) {
                Activator.handleError(e);
            }
            return resources.toArray(new String[0]);
        }

        private String getTextUriFromElement(OMElement linkElem) {
            String targets = linkElem.getAttributeValue(new QName("targets"));
            String[] values = targets.split("\\s");
            if (values.length < 2) {
                throw new RuntimeException(NLS.bind((String)"The target attribute in tei:link have {0} values.", (Object)values.length));
            }
            return values[1].split("#")[0];
        }
    }
}

