/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.tools;

import info.textgrid._import.RewriteMethod;
import info.textgrid.lab.core.importexport.model.IExportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.IImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.ISpecialImportEntrySupplier;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.RewriteSetup;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.linkeditor.tools.ImportExportUtils;
import info.textgrid.utils.linkrewriter.ConfigurableXMLRewriter;
import info.textgrid.utils.linkrewriter.ImportMapping;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class LinkFileConfigurator
implements IImportEntryConfigurator,
IExportEntryConfigurator {
    private static final RewriteSetup REWRITE_SETUP = RewriteSetup.of((RewriteMethod)RewriteMethod.XML, (String)"internal:tei#tei");
    private static String CONTENT_TYPE_ID = "text/linkeditorlinkedfile";

    public void configureImport(ImportEntry entry, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (this.isLinkFile(entry)) {
                entry.setRewriteSetup(REWRITE_SETUP);
                progress.worked(10);
                FileInputStream inputStream = new FileInputStream(entry.getLocalFile());
                progress.worked(10);
                if (progress.isCanceled()) {
                    return;
                }
                ImportExportUtils.TGObjectAnalyzer analyzer = ImportExportUtils.getObjectAnalyzer(inputStream);
                progress.worked(10);
                if (progress.isCanceled()) {
                    return;
                }
                String[] allUris = analyzer.getAllUris();
                progress.worked(10);
                if (progress.isCanceled()) {
                    return;
                }
                String parent = entry.getLocalFile().getParent();
                progress.setWorkRemaining(100 * allUris.length);
                ArrayList<URI> fileURIs = new ArrayList<URI>();
                String[] stringArray = allUris;
                int n = allUris.length;
                int n2 = 0;
                while (n2 < n) {
                    String uri = stringArray[n2];
                    URI parsedURI = URI.create(uri);
                    if (parsedURI.isAbsolute()) {
                        if ("file".equals(parsedURI.getScheme())) {
                            entry.addFile(new File(parsedURI), monitor);
                            fileURIs.add(parsedURI);
                        } else {
                            StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Cannot handle absolute URI {0} in link file {1}.", (Object)uri, (Object)entry.getLocalFile())));
                        }
                    } else {
                        entry.addFile(new File(parent, uri), (IProgressMonitor)progress.newChild(100));
                    }
                    ++n2;
                }
                if (!fileURIs.isEmpty()) {
                    entry.setSupplier((ISpecialImportEntrySupplier)new FileURISupplier(entry.getLocalFile(), fileURIs));
                }
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "info.textgrid.lab.linkeditor.controller");
        }
        catch (FileNotFoundException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.linkeditor.controller", NLS.bind((String)"Could not open the link file {0}. This is probably a bug.", (Object)e)));
        }
    }

    private boolean isLinkFile(ImportEntry entry) throws CoreException {
        return CONTENT_TYPE_ID.equals(entry.getObject().getContentTypeID());
    }

    public void configureExport(ImportEntry entry, IProgressMonitor monitor) {
        block7: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                if (!this.isLinkFile(entry)) break block7;
                entry.setRewriteSetup(REWRITE_SETUP);
                ImportExportUtils.TGObjectAnalyzer analyzer = ImportExportUtils.getObjectAnalyzer(entry.getObject());
                progress.worked(10);
                if (progress.isCanceled()) {
                    return;
                }
                String[] allUris = analyzer.getAllUris();
                progress.worked(10);
                progress.setWorkRemaining(100 * allUris.length);
                if (progress.isCanceled()) {
                    return;
                }
                String[] stringArray = allUris;
                int n = allUris.length;
                int n2 = 0;
                while (n2 < n) {
                    String document = stringArray[n2];
                    try {
                        URI uri = new URI(document);
                        TGObjectReference reference = new TGObjectReference(uri);
                        entry.addObject(reference, null, (IProgressMonitor)progress.newChild(100));
                    }
                    catch (URISyntaxException e) {
                        StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.linkeditor.controller", MessageFormat.format("The link file {0} references an invalid URI {1}, which was ignored during import configuration.", entry.getObject(), document), (Throwable)e));
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.linkeditor.controller");
            }
        }
    }

    public class FileURISupplier
    implements ISpecialImportEntrySupplier {
        private final List<URI> referredURIs;
        private final File linkFile;

        public FileURISupplier(File file, List<URI> fileURIs) {
            this.linkFile = file;
            this.referredURIs = fileURIs;
        }

        public InputStream getInputStream() throws IOException {
            ImportMapping mapping = new ImportMapping();
            URI linkFileURI = this.linkFile.toURI();
            for (URI uri : this.referredURIs) {
                mapping.add(uri.toString(), linkFileURI.relativize(uri).toString(), null, RewriteMethod.NONE);
            }
            ConfigurableXMLRewriter rewriter = new ConfigurableXMLRewriter(mapping, true);
            rewriter.configure(URI.create("internal:tei#tei"));
            rewriter.setBase(this.linkFile.getParentFile().toURI());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                FileInputStream input = new FileInputStream(this.linkFile);
                rewriter.rewrite((InputStream)input, (OutputStream)outputStream);
                outputStream.close();
                input.close();
                System.out.println(outputStream.toString("UTF-8"));
                return new ByteArrayInputStream(outputStream.toByteArray());
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }

        public File getFile() {
            return this.linkFile;
        }
    }
}

