/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.tools;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.linkeditor.controller.TeiFactory.OMUtil;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEIDocFactory;
import info.textgrid.lab.linkeditor.tools.Activator;
import info.textgrid.lab.linkeditor.tools.FetchTGObjectsDialog;
import info.textgrid.lab.linkeditor.tools.IProjectBrowserListener;
import info.textgrid.lab.linkeditor.tools.Messages;
import java.io.File;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.jaxen.JaxenException;

public class LinksObjectEditorSection
implements IProjectBrowserListener {
    private TableViewer firstTable = null;
    private TableViewer secondTable = null;
    private TableViewer lastSelectedViewer = null;
    private Map<String, String> nameUriMap1 = new HashMap<String, String>();
    private Map<String, String> nameUriMap2 = new HashMap<String, String>();
    private Group buttonsGrp = null;
    private Group urisGroup = null;

    private LinksObjectEditorSection getInstance() {
        return this;
    }

    public Composite create(Composite parent) {
        this.urisGroup = new Group(parent, 530);
        this.urisGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.urisGroup.setLayout((Layout)new GridLayout(3, true));
        this.urisGroup.setText("");
        this.firstTable = new TableViewer((Composite)this.urisGroup, 268438276);
        GridData urisTreeData1 = new GridData(4, 4, true, false);
        urisTreeData1.heightHint = 80;
        urisTreeData1.widthHint = 300;
        GridData urisTreeData2 = new GridData(4, 4, true, false);
        urisTreeData2.heightHint = 80;
        urisTreeData2.widthHint = 300;
        this.firstTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LinksObjectEditorSection.this.lastSelectedViewer = LinksObjectEditorSection.this.firstTable;
            }
        });
        Table table = this.firstTable.getTable();
        table.setLayoutData((Object)urisTreeData1);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tblclmnFirst = new TableColumn(table, 0);
        tblclmnFirst.setWidth(700);
        tblclmnFirst.setText(Messages.LinksObjectEditorSection_ReferencesInTheObject);
        this.secondTable = new TableViewer((Composite)this.urisGroup, 268438276);
        this.secondTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LinksObjectEditorSection.this.lastSelectedViewer = LinksObjectEditorSection.this.secondTable;
            }
        });
        this.lastSelectedViewer = this.secondTable;
        Table table2 = this.secondTable.getTable();
        table2.setLayoutData((Object)urisTreeData2);
        table2.setLinesVisible(true);
        table2.setHeaderVisible(true);
        TableColumn tblclmnFirst2 = new TableColumn(table2, 0);
        tblclmnFirst2.setWidth(700);
        tblclmnFirst2.setText(Messages.LinksObjectEditorSection_ReplaceWith);
        this.firstTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = event.getSelection();
                if (sel != null) {
                    String text = sel.toString();
                    String string = text.substring(1, text.length() - 1);
                }
            }
        });
        this.buttonsGrp = new Group((Composite)this.urisGroup, 4);
        this.buttonsGrp.setLayout((Layout)new GridLayout(1, true));
        this.buttonsGrp.setLayoutData((Object)new GridData(4, 0, true, false));
        Group addUriGrp = new Group((Composite)this.buttonsGrp, 4);
        addUriGrp.setText(Messages.LinksObjectEditorSection_AddNewObjects);
        addUriGrp.setLayout((Layout)new GridLayout(2, true));
        addUriGrp.setLayoutData((Object)new GridData(4, 0, true, false));
        Button getTGUriButton = new Button((Composite)addUriGrp, 8);
        getTGUriButton.setText(Messages.LinksObjectEditorSection_AddTGObjects);
        getTGUriButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FetchTGObjectsDialog.openDialog(LinksObjectEditorSection.this.getInstance());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button getLocalUriButton = new Button((Composite)addUriGrp, 8);
        getLocalUriButton.setText(Messages.LinksObjectEditorSection_AddLocalFiles);
        getLocalUriButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDlg = new FileDialog(getLocalUriButton.getShell(), 4098);
                fileDlg.setText(Messages.LinksObjectEditorSection_SelectedFiles);
                fileDlg.setFilterExtensions(new String[]{"*.xml;*.jpg;*.jpeg;*.png;*.tiff;*.tif", "*.xml", "*.jpg", "*.jpeg", "*.png", "*.tiff", "*.tif"});
                fileDlg.setFilterNames(new String[]{"All proper types", "XML file (*.xml)", "JPG file (*.jpg)", "JPEG file (*.jpeg)", "PNG file (*.png)", "TIFF file (*.tiff)", "TIFF file (*.tif)"});
                fileDlg.open();
                String[] filePaths = fileDlg.getFileNames();
                if (filePaths == null) {
                    return;
                }
                String[] stringArray = filePaths;
                int n = filePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    block5: {
                        String suffix;
                        String uri;
                        block7: {
                            String mimeType;
                            block6: {
                                String filePath = stringArray[n2];
                                File file = new File(filePath);
                                if (file == null) break block5;
                                uri = file.toURI().toString();
                                FileNameMap fileNameMap = URLConnection.getFileNameMap();
                                mimeType = fileNameMap.getContentTypeFor(file.getPath());
                                suffix = "";
                                if (mimeType == null || "".equals(mimeType)) break block5;
                                if (!mimeType.contains("image")) break block6;
                                suffix = ".";
                                break block7;
                            }
                            if (!"text/xml".equals(mimeType) && !"application/xml".equals(mimeType)) break block5;
                            suffix = "";
                        }
                        String name = LinksObjectEditorSection.this.getInfoFromUri(suffix, uri);
                        LinksObjectEditorSection.this.nameUriMap2.put(name, uri);
                        LinksObjectEditorSection.this.setSelectedTextInInput(name);
                    }
                    ++n2;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group removeUriGrp = new Group((Composite)this.buttonsGrp, 0);
        removeUriGrp.setText(Messages.LinksObjectEditorSection_RemoveSelectedObjects);
        removeUriGrp.setLayout((Layout)new GridLayout(2, true));
        removeUriGrp.setLayoutData((Object)new GridData(4, 0, true, false));
        Button removeButton = new Button((Composite)removeUriGrp, 8);
        removeButton.setText(Messages.LinksObjectEditorSection_RemoveSelectedObjects);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinksObjectEditorSection.this.removeSelectedObject();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group moveUriGrp = new Group((Composite)this.buttonsGrp, 0);
        moveUriGrp.setText(Messages.LinksObjectEditorSection_MoveSelectedObjects);
        moveUriGrp.setLayout((Layout)new GridLayout(2, true));
        moveUriGrp.setLayoutData((Object)new GridData(4, 0, true, false));
        Button up = new Button((Composite)moveUriGrp, 8);
        up.setText(Messages.LinksObjectEditorSection_Up);
        up.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinksObjectEditorSection.this.moveUp();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button down = new Button((Composite)moveUriGrp, 8);
        down.setText(Messages.LinksObjectEditorSection_Down);
        down.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LinksObjectEditorSection.this.moveDown();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return this.urisGroup;
    }

    public Group getSectionGroup() {
        return this.urisGroup;
    }

    public Group getButtonsGroup() {
        return this.buttonsGrp;
    }

    private void removeSelectedObject() {
        int index = this.lastSelectedViewer.getTable().getSelectionIndex();
        if (index >= 0) {
            this.lastSelectedViewer.getTable().remove(index);
            this.lastSelectedViewer.getTable().select(0);
        }
    }

    private void moveUp() {
        int index = this.lastSelectedViewer.getTable().getSelectionIndex();
        if (index >= 1) {
            TableItem item1 = this.lastSelectedViewer.getTable().getItem(index);
            TableItem item2 = this.lastSelectedViewer.getTable().getItem(index - 1);
            String tmp = item1.getText();
            item1.setText(item2.getText());
            item2.setText(tmp);
            Image tmpImage = item1.getImage();
            item1.setImage(item2.getImage());
            item2.setImage(tmpImage);
            this.lastSelectedViewer.getTable().setSelection(index - 1);
        }
    }

    private void moveDown() {
        int index = this.lastSelectedViewer.getTable().getSelectionIndex();
        if (index >= 0 && index < this.lastSelectedViewer.getTable().getItemCount() - 1) {
            TableItem item1 = this.lastSelectedViewer.getTable().getItem(index);
            TableItem item2 = this.lastSelectedViewer.getTable().getItem(index + 1);
            String tmp = item1.getText();
            item1.setText(item2.getText());
            item2.setText(tmp);
            Image tmpImage = item1.getImage();
            item1.setImage(item2.getImage());
            item2.setImage(tmpImage);
            this.lastSelectedViewer.getTable().setSelection(index + 1);
        }
    }

    public void clearAllItemsInFirstTable() {
        this.firstTable.setItemCount(0);
    }

    public void clearAllItemsInSecondTable() {
        this.secondTable.setItemCount(0);
    }

    public TableViewer getFirstTable() {
        return this.firstTable;
    }

    public TableViewer getSecondTable() {
        return this.secondTable;
    }

    public String getObjectUriFromTable1(String entry) {
        return this.nameUriMap1.get(entry);
    }

    public String getObjectUriFromTable2(String entry) {
        return this.nameUriMap2.get(entry);
    }

    public void addEntriesToFirstTable(String[] entries) {
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            TableItem item = new TableItem(this.firstTable.getTable(), 0);
            item.setText(s);
            if (s.endsWith(".")) {
                this.setImageIconToItem(item);
            } else {
                this.setXMLIconToItem(item);
            }
            ++n2;
        }
    }

    public void addEntriesToSecondTable(String[] entries) {
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            TableItem item = new TableItem(this.secondTable.getTable(), 0);
            item.setText(s);
            if (s.endsWith(".")) {
                this.setImageIconToItem(item);
            } else {
                this.setXMLIconToItem(item);
            }
            ++n2;
        }
    }

    @Override
    public void setSelectedTGObjectsFromDialog(TextGridObject[] tgObjs) {
        try {
            TextGridObject[] textGridObjectArray = tgObjs;
            int n = tgObjs.length;
            int n2 = 0;
            while (n2 < n) {
                block5: {
                    String suffix;
                    String uri;
                    block7: {
                        String contentType;
                        block6: {
                            TextGridObject tgObj = textGridObjectArray[n2];
                            uri = tgObj.getURI().toString();
                            contentType = tgObj.getContentTypeID();
                            suffix = "";
                            if (contentType == null || "".equals(contentType)) break block5;
                            if (!contentType.contains("image")) break block6;
                            suffix = ".";
                            break block7;
                        }
                        if (!"text/xml".equals(contentType)) break block5;
                        suffix = "";
                    }
                    String name = this.getInfoFromUri(suffix, uri);
                    this.nameUriMap2.put(name, uri);
                    this.setSelectedTextInInput(name);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.handleError(e);
        }
    }

    private void setSelectedTextInInput(String entry) {
        TableItem item = new TableItem(this.secondTable.getTable(), 0);
        item.setText(entry);
        if (entry.endsWith(".")) {
            this.setImageIconToItem(item);
        } else {
            this.setXMLIconToItem(item);
        }
    }

    public void setSelectedTGObject(TextGridObject tgObj) {
        this.updateUrisViewer(tgObj);
    }

    public void setSelectedFile(InputStream inputStream) {
        if (inputStream != null) {
            this.clearAllItemsInFirstTable();
            String[] entries = this.getEntries(inputStream);
            this.addEntriesToFirstTable(entries);
        }
    }

    private void updateUrisViewer(final TextGridObject tgObj) {
        if (tgObj != null) {
            this.clearAllItemsInFirstTable();
            new Job("Fetching data from Grid..."){

                protected IStatus run(IProgressMonitor monitor) {
                    IFile file = (IFile)tgObj.getAdapter(IFile.class);
                    try {
                        InputStream inputStream = file.getContents(true);
                        final String[] entries = LinksObjectEditorSection.this.getEntries(inputStream);
                        new UIJob(""){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                LinksObjectEditorSection.this.addEntriesToFirstTable(entries);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    catch (CoreException e) {
                        Activator.handleError(e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void setXMLIconToItem(TableItem item) {
        item.setImage(new Image((Device)PlatformUI.getWorkbench().getDisplay(), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/xmldoc.gif").getImageData()));
    }

    private void setImageIconToItem(TableItem item) {
        item.setImage(new Image((Device)PlatformUI.getWorkbench().getDisplay(), ImageDescriptor.createFromFile(this.getClass(), (String)"/icons/image_obj.gif").getImageData()));
    }

    private String[] getEntries(InputStream inputStream) {
        TreeSet<String> resources = new TreeSet<String>();
        try {
            OMElement root = new StAXOMBuilder(inputStream).getDocumentElement();
            if (!root.getLocalName().equals("TEI")) {
                return new String[]{"Error: Old style Text-Image-Link Object!"};
            }
            List imageElements = OMUtil.getElementListWithName((String)"image", (OMElement)root, (String)TEIDocFactory.SVG_NS_URI, (String)TEIDocFactory.SVG_NS_Prefix);
            for (OMElement e : imageElements) {
                String imageUri = e.getAttributeValue(new QName(TEIDocFactory.XLINK_NS_URI, "href", TEIDocFactory.XLINK_NS_Prefix));
                String entry = this.getInfoFromUri(".", imageUri);
                resources.add(entry);
                this.nameUriMap1.put(entry, imageUri);
            }
            List linkElems = OMUtil.getElementListWithName((String)"link", (OMElement)root, (String)TEIDocFactory.TEI_NS_URI, (String)TEIDocFactory.TEI_NS_Prefix);
            for (OMElement e : linkElems) {
                String textUri = this.getTextUriFromElement(e);
                String entry = this.getInfoFromUri("", textUri);
                if (entry == null) continue;
                resources.add(entry);
                this.nameUriMap1.put(entry, textUri);
            }
            return resources.toArray(new String[0]);
        }
        catch (JaxenException e) {
            Activator.handleError(e);
        }
        catch (Exception e) {
            Activator.handleError(e);
        }
        return null;
    }

    private String getInfoFromUri(String suffix, String uri) {
        try {
            if (uri.startsWith("textgrid")) {
                TextGridObject obj = TextGridObject.getInstance((URI)new URI(uri), (boolean)false);
                obj.reloadMetadata(false);
                return String.valueOf(obj.getNameCandidate()) + " (" + uri + ")" + suffix;
            }
            if (uri.startsWith("file")) {
                return String.valueOf(new File(new URI(uri)).getName()) + " (" + uri + ")" + suffix;
            }
        }
        catch (Exception e) {
            Activator.handleError(e, "Couldn't fetch the information of {0}", uri);
        }
        return null;
    }

    private String getTextUriFromElement(OMElement linkElem) {
        String targets = linkElem.getAttributeValue(new QName("targets"));
        String[] values = targets.split("\\s");
        if (values.length < 2) {
            throw new RuntimeException(NLS.bind((String)"The target attribute in tei:link have {0} values.", (Object)values.length));
        }
        return values[1].split("#")[0];
    }
}

