/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.tools;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.linkeditor.tools.Activator;
import info.textgrid.lab.linkeditor.tools.LinksObjectEditorSection;
import info.textgrid.lab.linkeditor.tools.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class LinksObjectEditorView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "info.textgrid.lab.linkeditor.controller.linksObjectEditorView";
    private TextGridObject tgObj = null;
    private Label urisDescLabel = null;
    private MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 196);
    private LinksObjectEditorSection linksObjectEditor = null;

    public void createPartControl(Composite parent) {
        Object obj;
        ISelection sel;
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.msgBox.setMessage(Messages.LinksObjectEditorView_TheSelectedTILObjectWillBeModified);
        this.msgBox.setText(Messages.LinksObjectEditorView_ModifiedTheSelectedTILObjects);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.urisDescLabel = new Label(parent, 64);
        GridData projectDescData = new GridData(4, 4, true, false);
        projectDescData.heightHint = 15;
        this.urisDescLabel.setLayoutData((Object)projectDescData);
        this.linksObjectEditor = new LinksObjectEditorSection();
        this.linksObjectEditor.create(parent);
        Group buttonsGrp = this.linksObjectEditor.getButtonsGroup();
        Group saveGrp = new Group((Composite)buttonsGrp, 0);
        saveGrp.setText(Messages.LinksObjectEditorView_Apply);
        saveGrp.setLayout((Layout)new GridLayout(1, true));
        saveGrp.setLayoutData((Object)new GridData(4, 0, true, false));
        Button saveBtn = new Button((Composite)saveGrp, 8);
        saveBtn.setText(Messages.LinksObjectEditorView_ApplyChanges);
        saveBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (LinksObjectEditorView.this.tgObj != null && LinksObjectEditorView.this.msgBox.open() == 64) {
                    LinksObjectEditorView.this.makeChangesPersistentAndReload();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        IViewPart naviView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.navigator.view");
        if (naviView != null && (sel = naviView.getSite().getSelectionProvider().getSelection()) != null && sel instanceof IStructuredSelection && (obj = ((IStructuredSelection)sel).getFirstElement()) != null) {
            TextGridObject tgO = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
            if (tgO == null) {
                return;
            }
            this.tgObj = tgO;
            try {
                this.linksObjectEditor.setSelectedTGObject(this.tgObj);
                this.urisDescLabel.setText(String.valueOf(Messages.LinksObjectEditorView_SelectedTILObject) + this.tgObj.getTitle() + " (" + this.tgObj.getURI().toString() + ")");
            }
            catch (Exception e) {
                Activator.handleError(e);
            }
        }
    }

    private void makeChangesPersistentAndReload() {
        TableItem[] selectedObjectItems = this.linksObjectEditor.getFirstTable().getTable().getItems();
        TableItem[] replaceItems = this.linksObjectEditor.getSecondTable().getTable().getItems();
        final int itemsCountFirstTable = selectedObjectItems.length;
        final int itemsCountSecondTable = replaceItems.length;
        final String[] selectedObjectItemsText = new String[itemsCountFirstTable];
        final String[] replaceItemsText = new String[itemsCountSecondTable];
        int i = 0;
        while (i < itemsCountFirstTable) {
            selectedObjectItemsText[i] = selectedObjectItems[i].getText();
            ++i;
        }
        i = 0;
        while (i < itemsCountSecondTable) {
            replaceItemsText[i] = replaceItems[i].getText();
            ++i;
        }
        Job savingTGOJob = new Job("Saving the object..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask("Saving the object...", 100);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IFile file = (IFile)LinksObjectEditorView.this.tgObj.getAdapter(IFile.class);
                    InputStream in = file.getContents(true);
                    OMElement root = new StAXOMBuilder(in).getDocumentElement();
                    root.serialize((OutputStream)baos);
                    monitor.worked(20);
                    String tree = baos.toString("UTF-8");
                    boolean changed = false;
                    String item1 = "";
                    String item2 = "";
                    String first = "";
                    String replaceWith = "";
                    int i = 0;
                    while (i < itemsCountFirstTable && i < itemsCountSecondTable) {
                        item1 = selectedObjectItemsText[i];
                        item2 = replaceItemsText[i];
                        if (item1.endsWith(".") && !item2.endsWith(".") || !item1.endsWith(".") && item2.endsWith(".")) {
                            Activator.handleError(new RuntimeException(), "It's not allowed to replace objects of different types!", new Object[0]);
                            return Status.CANCEL_STATUS;
                        }
                        first = LinksObjectEditorView.this.linksObjectEditor.getObjectUriFromTable1(item1);
                        replaceWith = LinksObjectEditorView.this.linksObjectEditor.getObjectUriFromTable2(item2);
                        tree = tree.replace(first, replaceWith);
                        changed = true;
                        ++i;
                    }
                    monitor.worked(20);
                    if (changed) {
                        file.setContents((InputStream)new ByteArrayInputStream(tree.getBytes("UTF-8")), 1, monitor);
                    }
                    monitor.done();
                    new UIJob("Reloading the URIs..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            LinksObjectEditorView.this.linksObjectEditor.setSelectedTGObject(LinksObjectEditorView.this.tgObj);
                            LinksObjectEditorView.this.linksObjectEditor.clearAllItemsInSecondTable();
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError(e);
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        savingTGOJob.schedule();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null) {
            TextGridObject tgO = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
            try {
                if (tgO == null || this.tgObj != null && tgO == this.tgObj || tgO != null && !"text/linkeditorlinkedfile".equals(tgO.getContentTypeID())) {
                    return;
                }
                this.tgObj = tgO;
                this.linksObjectEditor.setSelectedTGObject(this.tgObj);
                this.urisDescLabel.setText("Selected Text-Image-Link Object: " + this.tgObj.getTitle() + " (" + this.tgObj.getURI().toString() + ")");
            }
            catch (CoreException e) {
                Activator.handleError(e);
            }
        }
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }
}

